#include "defs.h"
#include "ring.h"
#include "gen_ring.h"
#include "error.e"
#include "globals.e"
#ifndef KANT
#include "alg.e"
#endif

t_handle ring_zero(h)
t_handle	h;
{
	t_handle	nelt;
	t_int		nitm;
	t_pfl		alg;
	t_grf           cring_fns;

	cring_fns = gen_ring_init_gprim_fns(h);
	alg = m_gringp_elt_coerce(cring_fns);
	if (!alg)
		error_internal("ring has no coersion routine");

	if (!(*alg)(h, structure_z, 0, 0, &nelt, &nitm, FALSE))
		error_runtime(ERR_ZERO_NOT_FOUND);
	return nelt;
}

t_handle ring_one(h)
t_handle	h;
{
	t_handle	nelt;
	t_int		nitm;
	t_pfl		alg;
	t_grf           cring_fns;

	cring_fns = gen_ring_init_gprim_fns(h);

	alg = m_gringp_elt_coerce(cring_fns);
	if (!alg)
		error_internal("ring has no coersion routine");

	if (!(*alg)(h, structure_z, 1, 0, &nelt, &nitm))
		error_runtime(ERR_ONE_NOT_FOUND);
	return nelt;
}


t_handle ring_minus_one(h)
t_handle	h;
{
	t_handle	nelt;
	t_int		nitm;
	t_pfl		alg;
	t_grf           cring_fns;

	cring_fns = gen_ring_init_gprim_fns(h);

	alg = m_gringp_elt_coerce(cring_fns);
	if (!alg)
		error_internal("ring has no coersion routine");

	if (!(*alg)(h, structure_z, -1, 0, &nelt, &nitm))
		error_runtime(ERR_MINUS_ONE_NOT_FOUND);
	return nelt;
}


t_void	ring_elt_delete(ring, elt)
t_handle	ring;
t_handle	*elt;
{
        t_pfv           alg;
        t_grf           cring_fns;
 
        cring_fns = gen_ring_init_gprim_fns(ring);

        alg = m_gringp_elt_delete(cring_fns);
        if (!alg)
                error_internal("ring has no deletion routine");

        (*alg)(ring, elt);
}

t_handle ring_elt_incref(ring, elt)
t_handle	ring, elt;
{
        t_pfh           alg; 
        t_grf           cring_fns; 
  
        cring_fns = gen_ring_init_gprim_fns(ring); 
 
        alg = m_gringp_elt_incref(cring_fns); 
        if (!alg) 
                error_internal("ring has no incref routine"); 
 
        return (*alg)(ring, elt);
}

t_handle ring_incref(ring)
t_handle	ring;
{
	return block_incref(ring);
}

t_void ring_delete(ring)
t_handle	*ring;
{
	switch(m_ring_type(*ring))
	{
		case RING_Z:
			z_str_delete(0, ring);
			break;
		case RING_ZM:
			zm_str_delete(0, ring);
			break;
		case RING_Q:
			q_str_delete(0, ring);
			break;
		case RING_R:
			real_str_delete(0, ring);
			break;
		case RING_C:
			comp_str_delete(0, ring);
			break;
		case RING_ORDER:
			order_str_delete(0, ring);
			break;
		default:
#ifdef KANT
			DIE();
#else
			ALG_STR_DELETE(*ring);
			*ring = NH;
#endif /* KANT */
	}
}
