
#include "defs.h"
#include "real.e"
#include "mp.e"

t_real
real_erf WITH_2_ARGS(
	t_handle,		r,
	t_real,		x
)
/*
** Returns y = erf(x) = sqrt(4/pi) * (integral from 0 to x of exp(-u^2) du).
*/
{
	mp_float	xf;
	mp_float	yf;

	real_make_mp( x, xf );
	yf = mp_alloc( real_base, real_beta_prec( r ));
	mp_erf( xf, yf );

	return mp_to_real( yf );
}


t_real
real_erfc WITH_2_ARGS(
	t_handle,		r,
	t_real,		x
)
/*
** Returns y = erfc(x) = 1 - erf(x).
*/
{
	mp_float	xf;
	mp_float	yf;

	real_make_mp( x, xf );
	yf = mp_alloc( real_base, real_beta_prec( r ));
	mp_erfc( xf, yf );

	return mp_to_real( yf );
}

