#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_power WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	t_int,	b
)
/*
Returns a ^ b.
*/
{
    Logical	first;
    rational	p, r, temp;

    if (b == 0)
	return q_incref(Q_ONE);

    if (b < 0)
    {
	p = q_inverse(field, a);
	b = -b;
    }
    else
	p = q_incref(a);

    first = TRUE;

    while (b)
    {
	if (b & 1)
	    if (first)
	    {
		first = FALSE;
		r = q_incref(p);
	    }
	    else
	    {
	       temp = r;
	       r = q_mult(field, r, p);
	       q_delref(temp);
	    }

	if (b >>= 1)
	{
	    temp = p;
	    p = q_mult(field, p, p);
	    q_delref(temp);
	}
    }

    q_delref(p);
    return r;
}

