#ifndef KANT
#include "alg.e"
#include "q.h"
#include "qm.e"
#include "quad.e"
#include "globals.e"
#include "eseq.e"
#include "ring.e"
#include "conv.e"
#include "structure.e"

t_logical
q_elt_coerce(qring, str, elt, itm, nelt, nitm, do_error)
t_handle	qring;
t_handle	str;
t_handle	elt;
t_int		itm;
t_handle	*nelt;
t_int		*nitm;
t_logical	do_error;
/*
** Lift elt into qring
*/
{
	t_int 	tmp;
	block_declarations;

	ASSERT (structure_repnum (qring) == REP_Q);


        switch (structure_varnum(str))
        {
	case VAR_RING:
		switch (ring_type(str))
		{
		case RING_Z:
			*nelt = q_integer_to_q(str, elt);
			break;
		case RING_Q:
			q_incref(elt);
			*nelt = elt;
			break;
		case RING_QUAD:
			if (!quad_coef_ev(elt, 1))
				*nelt = conv_quad_to_q(0, elt);
			else
				return FALSE;
			break;
		case RING_QM:
			if (m_qmelt_is_integer(elt))
			{
				*nelt = q_new();
				q_numer(*nelt) = integer_incref(elt);
				q_denom(*nelt) = 1;
				break;
			}
			for (tmp = qm_degree(str)- 1; tmp > 0; tmp--)
				if (qmelt_coef(elt, tmp) != 0)
					return FALSE;
			*nelt = q_new();
			q_numer(*nelt) = qmelt_coef(elt, 0);
			q_denom(*nelt) = qmelt_denom(elt);
			break;

		default:
			return FALSE;
		}
		break;
	case VAR_POW_SEQ: /* sequence of numer, denom  */
                if (eseq_length(elt) != 2)
                        return FALSE;
                if (eseq_univ_str(elt) != structure_z)
                        return FALSE;
                *nelt = conv_seq_to_q(qring, elt);
                break;

        default:       
                return FALSE;
        }

	*nitm = 0;
	return TRUE;
}

#else /* KANT */

#include "defs.h"
#include "q.h"
#include "globals.e"
#include "ring.e"
#include "conv.e"

t_logical
q_elt_coerce(qring, str, elt, itm, nelt, nitm, do_error)
t_handle	qring;
t_handle	str;
t_handle	elt;
t_int		itm;
t_handle	*nelt;
t_int		*nitm;
t_logical	do_error;
/*
** Lift elt into qring
*/
{
	block_declarations;

	ASSERT (structure_repnum (qring) == REP_Q);


	switch (ring_type(str))
	{
	case RING_Z:
		*nelt = q_integer_to_q(str, elt);
		break;
	case RING_Q:
		q_incref(elt);
		*nelt = elt;
		break;
	default:
		return FALSE;
	}

	*nitm = 0;
	return TRUE;
}

#endif /* KANT */
