#include "defs.h"
#include "principal_ideal.e"

t_handle
principal_ideal_str_meet(id1, id2)
t_handle	id1, id2;
{

	t_pi_context    context;

        pi_ctx_init(id1, &context);
        return pi_str_meet_ctx(&context, id1, id2);
}

t_handle pi_str_meet_ctx(context, id1, id2)
t_pi_ctx	context;
t_handle	id1, id2;
{
        t_handle        ring;
        t_pfh           elt_gcd;
        t_pfh           elt_mult;
        t_pfh           elt_quotrem;
	t_pfv		elt_delete;
	t_pi_elt	res;
	t_handle	g, g1, g2;
	t_handle	m, r, lcm;
	t_int		i;
	

	g1 = m_pi_generator(id1);
	g2 = m_pi_generator(id2);
	ring = m_pi_ctx_ring(context);
	elt_gcd = m_pi_ctx_elt_gcd(context);
	elt_mult = m_pi_ctx_elt_mult(context);
	elt_quotrem = m_pi_ctx_elt_quotrem(context);
	elt_delete = m_pi_ctx_elt_delete(context);
	ASSERT(elt_gcd);
	ASSERT(elt_mult);
	ASSERT(elt_quotrem);
	ASSERT(elt_delete);


        g = (*elt_gcd)(ring, g1, g2);
	(*elt_mult)(ring, g1, 0, g2, 0, &m, &i);
	(*elt_quotrem)(ring, m, g, &lcm, &r);
	res = principal_ideal_str_create(ring, lcm);
	(*elt_delete)(ring, &g);
	(*elt_delete)(ring, &m);
	(*elt_delete)(ring, &lcm);
	(*elt_delete)(ring, &r);
	return res;
	
}
