#include "defs.h"
#include "poly.h"

public t_poly
poly_z_printable_poly WITH_2_ARGS (
    t_handle,    pring,
    t_poly,   apoly
)
/*  Given a clean poly, remove all levels with one term and exp 0. */
{
    block_declarations;
    t_handle  aph, resph;
    t_int     nterms, termno;

    if (m_poly_const(apoly))
        return integer_incref (apoly);

    aph = m_poly_poly_to_handle (apoly);
    nterms = m_poly_nterms (aph);

    if (nterms == 1 && m_poly_expt (aph, 0) == 0)
        return poly_z_printable_poly (pring, m_poly_coefft (aph,0));

    m_poly_create_empty(&resph, m_poly_princvar (aph),
                                      m_poly_least_pvar (aph), nterms );

    for (termno = 0; termno < nterms; termno ++)
    {
        m_poly_expt (resph, termno) = m_poly_expt (aph, termno);
        m_poly_coefft (resph, termno) =
                  poly_z_printable_poly (pring, m_poly_coefft (aph, termno));
    }

    return m_poly_handle_to_poly(resph);
}

public t_void
poly_z_printable_delete WITH_2_ARGS (
    t_handle,    pring,
    t_poly,   apoly
)
/*  Given a printable poly, delete it. */
{
    block_declarations;
    m_poly_z_delref(pring, apoly);
}

