#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_lbase_coefft WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_LBASE_COEFFT: Returns the leading base coefficient of the
*    polynomial
*/
{
    block_declarations;
    t_handle           aph;
    t_poly        acoefft;
    t_int    nterms;

    if ( m_poly_const( apoly ) )
    {
        return  integer_incref( apoly );
    }

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    if ( nterms == 0 )
    {
        return  0;
    }

    acoefft = m_poly_coefft( aph, nterms - 1 );

    if ( m_poly_not_const( acoefft ) )
    {
        return poly_z_lbase_coefft( pring, acoefft );
    }

    /* constant acoefft */

    return  integer_incref( acoefft );

} /* poly_z_lbase_coefft() */


t_poly
poly_z_lead_coefft_svar WITH_3_ARGS(
    t_handle,           pring,
    t_poly,		apoly,
    t_int,	svar
)
/*
*    IPOLY_LBASE_COEFFT: Returns the leading coefficient of variable svar
*    in the polynomial
*/
{
    block_declarations;
    t_handle           aph;
    t_poly        acoefft;
    t_int    nterms;

    if ( m_poly_const( apoly ) )
    {
        return  integer_incref( apoly );
    }

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    if ( nterms == 0 )
    {
        return  0;
    }

    if ( m_poly_princvar( aph ) > svar )
	return m_poly_z_incref( pring, apoly );

    acoefft = m_poly_coefft( aph, nterms - 1 );

    if ( m_poly_const( acoefft ) )
	return integer_incref( acoefft );

    if ( m_poly_princvar( aph ) == svar )
	return m_poly_z_incref( pring, acoefft );

    return poly_z_lead_coefft_svar( pring, acoefft, svar );

} /* poly_z_lead_coefft_svar() */



t_poly
poly_z_lead_coefft WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_LEAD_COEFFT: Returns the leading coefficient of the polynomial
*/
{
    block_declarations;
    t_handle           aph;
    t_int    nterms;

    if ( m_poly_const( apoly ) )
    {
        return  integer_incref( apoly );
    }

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );

    if ( nterms == 0 )
    {
        return  0;
    }

    return  m_poly_z_incref( pring, m_poly_coefft( aph, nterms - 1 ) );

} /* poly_z_lead_coefft() */

