#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "globals.e"
#include "error.e"

t_handle
poly_z_factorize ( pring, elt)
t_handle	pring;
t_poly		elt;
{
	t_handle  flist;
	t_int	  cont, sgn;

	DENY(m_poly_const (elt));
	ASSERT (m_poly_univariate (m_poly_poly_to_handle(elt)));
	if (poly_deg (elt) == 0)
	{
		flist = m_poly_z_faclst_alloc(1);
                poly_z_faclst_add_factor(flist, pring, elt, 1);
		return flist;
	}
	poly_u_z_factorize (pring,elt, &sgn, &cont, &flist);
	poly_z_farray_add_content(pring, sgn, cont, flist);
	return flist;
}

