#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "dyn_arr.h"

t_int
poly_z_factor_coef_bound WITH_1_ARG (
	t_handle,      vector
)

/* IPFCB:  Integral polynomial factor coefficient bound */
/* assumes that num is a small int, but prod may get big */

{
    block_declarations;
    integer_big   num, deg, prod, temp;
    t_int         len, index;

    num = 0;
    prod = 1;
    len = dyn_arr_curr_length (vector);

    for (index = 0; index < len; index ++)
    {
        deg = dyn_arr_element (vector, index);
        if (deg > 0)
        {
            num = num + deg + deg - 1;
            temp = prod;
            prod = integer_mult (temp, deg + 1);
            integer_delref (temp);
        }
    }
    num += integer_log2(prod);
    integer_delref (prod);
    return ((num+1)/2);
}
