
#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_evaluate WITH_4_ARGS(
    t_handle,       pring,
    t_poly,      apoly,
    t_int,   i,               /* no. of var being evaluated  */
    integer_big,     aint             /* value to be substituted     */
)
/*
*    IPOLY_EVALUATE : integral polynomial evaluation.
*    apoly is an integral poly in r variables 1<= i <= r
*    aint is an integer. poly_z_evaluate returns :
*    B(x1,...x(i-1),x(i+1),...xr) = A(x1,...x(i-1),aint,x(i+1),...xr)
*/
{
    block_declarations;
    t_handle           resph;           /* t_handle to result polynomial */
    t_handle           aph;             /* t_handle to apoly             */
    t_poly        temppoly;        /* temporary polynomial        */
    t_poly        respoly;         /* result polynomial           */
    t_int    nterms;          /* no. terms in apoly          */
    t_int    termno;          /* loop counter for apoly      */
    t_poly        acoefft;
    t_int    aexpt;

    if ( m_poly_const( apoly ) )
    {
        return  integer_incref( apoly );
    }

    aph = m_poly_poly_to_handle( apoly );
    
    if ( i == m_poly_princvar( aph ) )
    {
        /* evaluation of principal variable */
        return( poly_z_eval_princvar( pring, apoly, aint ) );
    }

    if ( (i < m_poly_princvar( aph )) || (i > m_poly_least_pvar( aph )) )
    {
        /* polynomial constant w.r.t. required variable */
        /* no evaluation necessary                      */

        return  m_poly_z_incref( pring, apoly );
    }

    /* general case : evaluation in var present in polynomial    */
    /*  i.e.  m_poly_princvar (aph) < i <= poly_leasst_pvar (aph)  */

    nterms = m_poly_nterms( aph );

    m_poly_create_empty(&resph, m_poly_princvar( aph ),
                                      m_poly_least_pvar( aph ), nterms );
    respoly = m_poly_handle_to_poly( resph );

    for ( termno = 0; termno < nterms; termno++ )
    {
        /* evaluate each term w.r.t. ith variable */

        aexpt = m_poly_expt( aph, termno );
        acoefft = m_poly_coefft( aph, termno );
        temppoly = poly_z_evaluate( pring, acoefft, i, aint );
    
        m_poly_coefft( resph, termno ) = temppoly;
        m_poly_expt( resph, termno ) = aexpt;
    }

    return  poly_z_clean( pring, respoly );

} /* poly_z_evaluate() */



t_poly
poly_z_eval_princvar WITH_3_ARGS(
    t_handle,     pring,
    t_poly,    apoly,
    integer_big,   aint      /* value to be substituted for var */
)
/*
*    IPOLY_EVAL_PRINCVAR : integral polynomial evaluation of principal
*    variable. apoly is an integral polynomial, aint an integer.
*    poly_z_eval_princvar(pring,apoly,aint) =
*     B(x1,...,x(r-1)) = A(x1,..,x(r-1),aint)
*/
{
    block_declarations;
    t_handle           aph;        /* t_handle to apoly                 */
    t_int    nterms;     /* no. terms in apoly              */
    t_int    termno;     /* loop counter                    */
    t_poly        acoefft;
    t_int    aexpt;
    t_poly        respoly;    /* result polynomial               */
    t_poly        temp;
    t_poly        temp2;

    if ( m_poly_const( apoly ) )
    {
        /* constant polynomial */
        return  integer_incref( apoly );
    }

    /* general case for non-trivial polynomial */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    if (m_poly_univariate (aph))
        respoly = 0;
    else
        respoly= poly_z_zero_poly (pring, m_poly_coefft (aph, 0));

    for ( termno = 0; termno < nterms; termno++ )
    {
        /* apply Horner's method */

        acoefft = m_poly_coefft( aph, termno );
        aexpt = m_poly_expt( aph, termno );

	temp = integer_power( aint, aexpt );
	temp2 =  poly_z_integer_mult( pring, acoefft, temp );
	integer_delref( temp );
	temp = respoly;
        respoly = poly_z_add( pring, temp2, temp );
	m_poly_z_delref( pring, temp2 );
	m_poly_z_delref( pring, temp );
    }

    return  respoly;

} /* poly_z_eval_princvar() */

