#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

Logical
poly_z_different WITH_3_ARGS(
    t_handle,     pring,
    t_poly,    apoly,
    t_poly,    bpoly
)
/*
** poly_z_different: check if two integer polynomials are
** different, returning 1 if they are different, 0 otherwise
*/
{
    t_int    nterms;
    t_int    termno;
    t_handle           aph;
    t_int    aexpt;
    t_handle           bph;
    t_int    bexpt;

    if ( m_poly_const( apoly ) && m_poly_const( bpoly ) )
    {
	return  ( integer_compare( apoly, bpoly ) != 0 );
    }

    if ( m_poly_const( apoly ) || m_poly_const( bpoly ) )
    {
        error_internal ("polys not lifted in poly_z_different\n");
	return  TRUE;
    }

    if (apoly == bpoly)
    {
        return FALSE;
    }

    aph = m_poly_poly_to_handle( apoly );
    bph = m_poly_poly_to_handle( bpoly );

    if ( m_poly_princvar( aph ) != m_poly_princvar( bph ) )
    {
        return  TRUE;
    }

    if ( m_poly_least_pvar( aph ) != m_poly_least_pvar( bph ) )
    {
        return  TRUE;
    }

    nterms = m_poly_nterms( aph );
    if (nterms != m_poly_nterms( bph ))
    {
        return TRUE;
    }


    for (termno = 0; termno < nterms; termno ++)
    {
        aexpt = m_poly_expt( aph, termno );
        bexpt = m_poly_expt( bph, termno );

        if ( aexpt != bexpt )
        {
            return  TRUE;
        }
        else if ( poly_z_different( pring, m_poly_coefft( aph, termno ),
                                   m_poly_coefft( bph, termno ) ) )
        {
            return  TRUE;
        }
    }

    return  FALSE;

} /* poly_z_different() */

