#include "defs.h"
#include "integer.e"
#include "modint.e"
 
integer_big
poly_z_const_chin_rem WITH_5_ARGS(
    integer_big,    m1,
    t_int,    m2,
    t_int,    m1dash,
    integer_big,    a1,
    t_int,    a2
)
/*
** input:  m1, m2 - positive integers s.t.
** gcd (m1, m2) = 1 and
** m = m1 * m2 
** m1dash = (m1 % m2) ^ -1
** a1, a2 - integers in Z_m1, Z_m2 respectively
** output: imdcra = unique element of Z_m s.t.
** it is congruent to a1 mod m1 and
** congruent to a2 mod m2
** computes the integer chinese remainder algorithm.
*/
{
        block_declarations;
        integer_big    dif;
        integer_big    temp;
 
        /*
         * case result = a1?  
         */
        temp = integer_rem (a1, m2); 
        dif = modint_subtract (m2, a2, temp);
        if (dif == 0)
        {
                return integer_incref (a1);
        }
        /*
         * general case...
         */
        temp = modint_mult (m2, dif, m1dash);
        dif = integer_mult (m1, temp);
        temp = integer_add (dif, a1);
        integer_delref (dif);
        return (temp);
}

