#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_mat.h"
#include "zm.e"
#include "error.e"

t_void
poly_u_zm_d_rem ( pdig, phdl, deg1, arg1, deg2, arg2, degres, res)
integer_big pdig;
t_matrix phdl;
t_int deg1, arg1, deg2, arg2, *degres, res;
/*
** Dense modular univariate polynomial calculations.
** res := arg1 mod arg2
*/
{
	block_declarations;
	t_int	i;
	t_int	j;
	integer_big	temp1;
	integer_big	temp2;
	integer_big	lcoefft;
	t_int	len;
	t_int	resoff;
	t_int	resoffk;
	t_int	arg1off;
	t_int	arg2off;

	len = m_poly_mat_col( phdl );

	DENY ( len < deg1 || len < deg2 );

	resoff = (res - 1) * len;
	arg1off = (arg1 - 1) * len;
	arg2off = (arg2 - 1) * len;

	if ( deg2 == 0 )
	{
		error_internal( "division by dense zero polynomial" );
	}

	ASSERT (m_poly_mat_entry( phdl, arg2off + deg2 ) != 0);

	if ( deg1 == 0 )
	{
		*degres = 0;
		return;
	}

	ASSERT (m_poly_mat_entry( phdl, arg1off + deg1 ) != 0);

	for ( i=1; i<=deg1; ++i )
	{
		temp1 = m_poly_mat_entry( phdl, resoff + i );
		integer_delref( temp1 );
		temp1 = m_poly_mat_entry( phdl, arg1off + i );
		m_poly_mat_entry( phdl, resoff + i ) = integer_incref( temp1 );
	}

	/* this may not be needed */
	for ( ; i<=len; ++i )
	{
		temp1 = m_poly_mat_entry( phdl, resoff + i );
		integer_delref( temp1 );
		m_poly_mat_entry( phdl, resoff + i ) = 0;
	}

	for ( i=deg1; i>=deg2; --i )
	{
		lcoefft = m_poly_mat_entry( phdl, resoff + i );

		if ( lcoefft == 0 )
		{
			continue;
		}

		resoffk = resoff + i - deg2;

		for ( j=1; j<deg2; ++j )
		{
			temp1 = m_poly_mat_entry( phdl, arg2off + j );
			temp2 = modint_mult( pdig, lcoefft, temp1 );
			temp1 = m_poly_mat_entry( phdl, resoffk + j );
			m_poly_mat_entry( phdl, resoffk + j ) = modint_subtract( pdig, temp1, temp2 );
			integer_delref( temp1 );
			integer_delref( temp2 );
		}

		integer_delref( lcoefft );
		m_poly_mat_entry( phdl, resoff + i ) = 0;
	}

	for ( i = deg2 - 1; ; --i )
	{
		if ( i == 0 || m_poly_mat_entry( phdl, resoff + i ) != 0 )
		{
			*degres = i;
			return;
		}
	}
}

