#include "poly.h"

t_poly
poly_evaluate (pring, apoly, i, aint)
t_handle	pring;
t_poly		apoly;
t_int		i;               /* no. of var being evaluated  */
t_handle	aint;            /* value to be substituted     */
/*
*    polynomial evaluation.
*    apoly is a poly in r variables 1<= i <= r
*    aint is an integer. poly_z_evaluate returns :
*    B(x1,...x(i-1),x(i+1),...xr) = A(x1,...x(i-1),aint,x(i+1),...xr)
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_evaluate_crf(&context, apoly, i, aint);
}

t_poly
poly_evaluate_crf(context, apoly, i, aint)
t_poly_ctx	context;
t_poly		apoly;
t_int		i;
t_handle	aint;
{
	t_poly        respoly;         /* result polynomial           */
	t_handle           resph;           /* t_handle to result polynomial */
	t_polyp           resp;
	t_poly        temppoly;        /* temporary polynomial        */
	t_int    nterms;          /* no. terms in apoly          */
	t_int    termno;          /* loop counter for apoly      */
	t_poly        acoefft;
	t_int    aexpt;
	t_polyp		ap;
	t_pfh		elt_incref;
	t_handle	cring;
	t_int		univ;


	DENY ( m_poly_const( apoly ) );

	ap = m_poly_to_ptr( apoly );
    
	if ( i == m_polyp_princvar( ap ) )
	{
		/* evaluation of principal variable */
		return( poly_eval_princvar_crf(context, apoly, aint ) );
	}

	if ( (i < m_polyp_princvar( ap )) || (i > m_polyp_least_pvar( ap )) )
	{
		/* polynomial constant w.r.t. required variable 
		** no evaluation necessary                      
		*/
		return poly_elt_incref_crf(context, apoly );
	}
	/* general case : evaluation in var present in polynomial 
	**  i.e.  m_polyp_princvar (ap) < i <= polyp_least_pvar(ap)  
	*/
	nterms = m_polyp_nterms( ap );
	m_poly_create_empty(&resph, m_polyp_princvar( ap ),
                                      m_polyp_least_pvar( ap ), nterms );
	respoly = m_poly_handle_to_poly( resph );
	resp = m_poly_hdl_to_ptr(resph);

	univ = m_polyp_univariate(ap);
	if (univ)
	{
		elt_incref = m_poly_ctx_elt_incref(context);
		cring = m_poly_ctx_cring(context);
	}
	for ( termno = 0; termno < nterms; termno++ )
	{
		/* evaluate each term w.r.t. ith variable */

		aexpt = m_polyp_expt( ap, termno );
		acoefft = m_polyp_coefft( ap, termno );
		if (univ)
		{
			temppoly =  (* elt_incref)(cring, acoefft );
		}
		else
		{
			temppoly = poly_evaluate_crf( context, acoefft, i, aint );
		}

		m_polyp_coefft( resp, termno ) = temppoly;
		m_polyp_expt( resp, termno ) = aexpt;
	}

	return  poly_clean_crf( context, respoly );

}



t_poly
poly_eval_princvar (pring, apoly, aint)
t_handle	pring;
t_poly		apoly;
t_handle	aint;      /* value to be substituted for var */
/*
*    polynomial evaluation of principal variable.
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_eval_princvar_crf(&context, apoly, aint);
}

t_poly
poly_eval_princvar_crf(context, apoly, aint)
t_poly_ctx	context;
t_poly		apoly;
t_handle	aint;
{
	t_int    nterms;     /* no. terms in apoly              */
	t_int    termno;     /* loop counter                    */
	t_poly        acoefft;
	t_int    aexpt;
	t_poly        respoly;    /* result polynomial               */
	t_polyp		ap;
	t_poly        temp;
	t_poly        temp2;
	t_handle	cring;
	t_pfh		elt_incref;
	t_pfh		elt_power;
	t_pfv		elt_delete;
	t_pfh		elt_add;
	t_pfh		elt_mult;
	t_handle	s;
	t_int		it;
	t_polyp		resp;
	t_poly		pow;
	t_poly		rcoeff;
	t_int		univ;


	elt_power = m_poly_ctx_elt_power(context);
	elt_mult = m_poly_ctx_elt_mult(context);
	elt_add = m_poly_ctx_elt_add(context);
	elt_delete = m_poly_ctx_elt_delete(context);
	cring = m_poly_ctx_cring(context);
	elt_incref = m_poly_ctx_elt_incref(context);

	DENY ( m_poly_const( apoly ) );

	/* general case for non-trivial polynomial */

	ap = m_poly_to_ptr( apoly );
	nterms = m_polyp_nterms( ap );
	respoly = poly_zero_poly_crf(context, apoly);
	resp = m_poly_to_ptr(respoly);
	univ = m_polyp_univariate(ap);

	for ( termno = 0; termno < nterms; termno++ )
	{
		/* apply Horner's method */

		acoefft = m_polyp_coefft( ap, termno );
		aexpt = m_polyp_expt( ap, termno );

		rcoeff = m_polyp_coefft(resp, 0);
		if (aexpt)
		{
			(* elt_power)(cring, aint, 0,  aexpt, &s, &pow, &it );
		}
		else
		{
			/* x^0 == 1 */
			pow = poly_z_embed_crf(context, 1);
		}
		if (univ)
		{
			(*elt_mult)(cring, acoefft, 0, pow, 0, &temp2, &it);
			(*elt_add)(cring, temp2, rcoeff, &temp);
			m_polyp_coefft(resp,0) = temp;
			(* elt_delete)(cring, &temp2 );
			(* elt_delete)(cring, &rcoeff );
		}
		else
		{
			temp2 =  poly_scalar_mult_crf(context, acoefft, pow );
			m_polyp_coefft(resp,0)=poly_add_crf(context,temp2,rcoeff);
			poly_elt_delete_crf(context, &temp2 );
			poly_elt_delete_crf(context, &rcoeff );
		}
		(* elt_delete)(cring, &pow );
	}

	return  respoly;
} 

