#include "defs.h"
#include "poly.h"

t_void
polyp_copy_term_crf(context, ptop, totermno, fromp, fromtermno)
t_poly_ctx      context;
t_polyp         ptop;
t_int           totermno;
t_polyp         fromp;
t_int   	fromtermno;
/* 
** Pointer version of poly_copy_term.
*/
{
        t_poly  	coefft;
	t_handle	cring;
	t_pfh		elt_incref;
	t_int		univ;

	elt_incref = m_poly_ctx_elt_incref(context);
	cring = m_poly_ctx_cring(context);
 
        ASSERT( totermno >= 0);
        ASSERT( fromtermno >= 0);
        ASSERT( fromtermno < m_polyp_nterms( fromp ));
    
	univ = m_polyp_univariate(fromp);
        coefft = m_polyp_coefft( fromp, fromtermno );
	if (univ)
	{
		m_polyp_coefft(ptop,totermno) = (*elt_incref)(cring, coefft);
	}
	else
	{
		m_polyp_coefft(ptop,totermno) = poly_elt_incref_crf(context,coefft);
	}
        m_polyp_expt(ptop,totermno ) = m_polyp_expt(fromp, fromtermno );
        return;
}

t_poly
poly_copy_poly(pring, apoly)
t_handle	pring;
t_poly	apoly;
/*
*    POLY_COPY_POLY: Copies one whole polynomial and returns a separate copy
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_copy_poly_crf(&context, apoly);
}

t_poly
poly_copy_poly_crf(context, apoly)
t_poly_ctx		context;
t_poly	apoly;
{
	t_handle           resph;
	t_polyp		   resp;
	t_polyp           ap;
	t_int    nterms;
	t_int    termno;
	t_int		univ;
	t_poly        coeff;
	t_handle	cring;
	t_pfh		elt_incref;

	cring = m_poly_ctx_cring(context);
	elt_incref = m_poly_ctx_elt_incref(context);

	DENY ( m_poly_const( apoly ) );

	ap = m_poly_to_ptr( apoly );
	nterms = m_polyp_nterms(ap);
	m_poly_create_empty(&resph, m_polyp_princvar( ap ),
					    m_polyp_least_pvar( ap ), nterms );
	resp = m_poly_hdl_to_ptr(resph);

	/* copy term by term */
	univ = m_polyp_univariate(ap);
	for ( termno = 0; termno < nterms; termno++ )
	{
		coeff = m_polyp_coefft( ap, termno );
		if (univ)
		{
			m_polyp_coefft(resp, termno) = (*elt_incref)(cring, coeff);
		}
		else
		{
			m_polyp_coefft(resp,termno)=poly_elt_incref_crf(context,coeff);
		}
		m_polyp_expt( resp, termno ) = m_polyp_expt( ap, termno );
	}
	return m_poly_handle_to_poly(resph);
}

