#include "defs.h"
#include "poly.h"


t_poly
poly_constant_dims_crf ( context, pvar, lpvar, aint)
t_poly_ctx	 context;
t_int		 pvar;
t_int	 	lpvar;
t_handle	 aint;
{
	t_poly      	respoly;
	t_handle       	temp;
	t_polyp		tempp;
	t_int 		varno;
	t_pfh		elt_incref;
	t_handle	cring;

	elt_incref = m_poly_ctx_elt_incref(context);
	cring = m_poly_ctx_cring(context);

	respoly =  ((*elt_incref)(cring, aint));

	for (varno = lpvar; varno >= pvar; varno --)
	{
		m_poly_create_empty (&temp, varno, lpvar, 1);
		tempp = m_poly_hdl_to_ptr(temp);
		m_polyp_coefft (tempp, 0) = respoly;
		m_polyp_expt (tempp, 0) = 0;
		respoly = m_poly_handle_to_poly(temp);
	}
	return respoly;

} /* poly_constant_dims_crf () */


t_poly
poly_constant_dims ( pring, pvar, lpvar, aint)
t_handle	 pring;
t_int	 pvar;
t_int	 lpvar;
t_handle	 aint;
/*
 * create the constant polynomial with the same princvar and
 * least_princvar as apoly and value aint.
 */
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_constant_dims_crf(&context, pvar, lpvar, aint);
}


t_poly
poly_constant_poly_crf(context, apoly, aint)
t_poly_ctx	context;
t_poly		apoly;
t_handle	aint;
{
	t_polyp       	ap;
	t_int   	lpvar;
	t_int   	pvar;
	t_pfh		elt_incref;
	t_handle	cring;

	elt_incref = m_poly_ctx_elt_incref(context);
	cring = m_poly_ctx_cring(context);

	DENY (m_poly_const (apoly));

	ap = m_poly_to_ptr (apoly);
	pvar = m_polyp_princvar (ap);
	lpvar = m_polyp_least_pvar (ap);

	return poly_constant_dims_crf (context, pvar, lpvar, aint);
}

t_poly
poly_constant_poly (pring, apoly, aint)
t_handle    pring; 
t_poly   apoly; 
t_handle    aint;
/*
 * create the constant polynomial with the same princvar and
 * least_princvar as apoly and value aint.
 */
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_constant_poly_crf(&context, apoly, aint);
}

t_poly	
poly_zero_poly_crf(context, apoly)
t_poly_ctx	context;
t_poly	apoly;
{
	t_handle	res,  z, cring;

	cring = m_poly_ctx_cring(context);
	res = poly_constant_poly_crf(context, apoly, z = ring_zero(cring));
	ring_elt_delete(cring, &z);
	return res;
}

t_poly	
poly_zero_poly(pring, apoly)
t_handle	pring;
t_poly	apoly;
{
	t_poly_context	context;
	
	poly_init_context(pring, &context);
	return poly_zero_poly_crf(&context, apoly);
}
