#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"

t_poly
modpoly_add( pring, mdig, apoly, bpoly )
t_handle pring;
integer_big mdig;
t_poly apoly, bpoly;
/*
**   modpoly_add: modular polynomial sum
**   apoly, bpoly are polynomials over Zmdig
**   returns ( apoly + bpoly ) mod mdig .
*/
{
	t_handle		resph;
	t_handle		aph;
	t_handle		bph;
	t_int	anterms;
	t_int	bnterms;
	t_int	resnterms;
	t_int	restermno;
	t_int	atermno;
	t_int	btermno;
	t_poly       acoefft;
	t_poly       bcoefft;
	t_int	aexpt;
	t_int	bexpt;
	t_poly       temp;

	if ( m_poly_const( apoly ) && m_poly_const( bpoly ) )
	{
		return modint_add( mdig, apoly, bpoly );
	}

	if ((m_poly_const (apoly)) || (m_poly_const (bpoly)))
	{
		/* one is constant, other not */

                error_internal ("modpoly_add: polys not lifted\n");
		return 0;
	}

	/* apoly and bpoly both non-constant */

	aph = m_poly_poly_to_handle( apoly );
	bph = m_poly_poly_to_handle( bpoly );

	anterms = m_poly_nterms( aph );
	bnterms = m_poly_nterms( bph );

	/* general case, both non-constant */

#ifdef DEBUG
	if ((m_poly_princvar (aph)   != m_poly_princvar (bph))
         || (m_poly_least_pvar (aph) != m_poly_least_pvar (bph)))
	{
                error_internal ("modpoly_add: polys not lifted\n");
		return 0;
	}
#endif /* DEBUG */

	/* principal variables equal */

	atermno = btermno = restermno = 0;

	resnterms = anterms + bnterms;
	m_poly_create_empty( &resph, m_poly_princvar (aph),
                                    m_poly_least_pvar (aph), resnterms );

	while ( ( atermno < anterms ) && ( btermno < bnterms ) ) 
	{
		aexpt = m_poly_expt( aph, atermno );
		bexpt = m_poly_expt( bph, btermno );

		if ( aexpt < bexpt )
		{
			acoefft = m_poly_coefft( aph, atermno );
			m_poly_coefft( resph, restermno ) = m_modpoly_incref( pring, acoefft );
			m_poly_expt( resph, restermno ) = aexpt;
			restermno++;
			atermno++;
		}
		else if ( aexpt > bexpt )
		{
			bcoefft = m_poly_coefft( bph, btermno );
			m_poly_coefft( resph, restermno ) = m_modpoly_incref( pring, bcoefft );
			m_poly_expt( resph, restermno ) = bexpt;
			restermno++;
			btermno++;
		}
		else
		{
			/* aexpt == bexpt */

			m_poly_expt( resph, restermno ) = aexpt;
			acoefft = m_poly_coefft( aph, atermno );
			bcoefft = m_poly_coefft( bph, btermno );

			if ( m_poly_univariate (aph) )
			{
				temp = modint_add( mdig, acoefft, bcoefft );
			}
			else
			{
				temp = modpoly_add( pring, mdig, acoefft, bcoefft );
			}

			m_poly_coefft( resph, restermno ) = temp;
			m_poly_expt( resph, restermno ) = aexpt;
			restermno++;
			atermno++;
			btermno++;
		}
	} /* end of while */

	/* copy rest of apoly */
	for ( ; atermno < anterms; atermno++, restermno++ )
	{
		acoefft = m_poly_coefft( aph, atermno );
		m_poly_coefft( resph, restermno ) = m_modpoly_incref( pring, acoefft );
		m_poly_expt( resph, restermno ) = m_poly_expt( aph, atermno );
	}

	/* copy rest of bpoly */
	for ( ;btermno < bnterms; btermno++, restermno++ )
	{
		bcoefft = m_poly_coefft( bph, btermno );
		m_poly_coefft( resph, restermno ) = m_modpoly_incref( pring, bcoefft );
		m_poly_expt( resph, restermno ) = m_poly_expt( bph, btermno );
	}

	m_poly_nterms( resph ) = restermno;
	return poly_z_clean (pring, m_poly_handle_to_poly( resph ));
}



#if 0
t_poly
modpoly_integer_add WITH_3_ARGS(
	integer_big,	mdig,
	t_poly,	apoly,
	integer_big,	acoefft
)
/*
** modpoly_integer_add : modular polynomial addition of integer
** apoly is a polynomial over Zmdig
** acoefft is an integer
** returns : ( apoly + acoefft ) mod mdig.
*/
{
	trbl_declarations;
	t_handle		resph;
	t_handle		aph;
	t_int	nterms;
	t_int	atermno;
	t_poly	temp;

	if ( acoefft == 0 )
	{
		return m_modpoly_incref( apoly );
	}

	if ( apoly == 0 )
	{
		return integer_incref( acoefft );
	}

	if ( m_poly_const( apoly ) )
	{
		return modint_add( mdig, apoly, acoefft );
	}

	/* general case: non-trivial polys */

	aph = m_poly_poly_to_handle( apoly );
	nterms = m_poly_nterms( aph );

	if ( m_poly_expt( aph, 0 ) == 0 )
	{
		/* constant term exists, add to it & copy remaining terms */

		temp = modpoly_integer_add( mdig, m_poly_coefft( aph, 0 ), acoefft );

		if ( temp != 0 )
		{
			m_poly_create_empty( &resph, m_poly_princvar( aph ), nterms );

			m_poly_coefft( resph, 0 ) = temp;
			m_poly_expt( resph, 0 ) = 0;

			/* copy remaining terms */

			for ( atermno = ( nterms - 1 ); atermno > 0; atermno-- )
			{
				acoefft = m_poly_coefft( aph, atermno );
				m_poly_coefft( resph, atermno ) = m_modpoly_incref( acoefft );
				m_poly_expt( resph, atermno ) = m_poly_expt( aph, atermno );
			}

			m_poly_nterms( resph ) = nterms;
		}
		else
		{
			if ( nterms == 1 )
			{
				return 0;
			}

			/* copy terms other than first */

			m_poly_create_empty( &resph, m_poly_princvar( aph ), nterms - 1 );

			for ( atermno = ( nterms - 1 ); atermno > 0; atermno-- )
			{
				acoefft = m_poly_coefft( aph, atermno );
				m_poly_coefft( resph, atermno-1 ) = m_modpoly_incref( acoefft );
				m_poly_expt( resph, atermno-1 ) = m_poly_expt( aph, atermno );
			}

			m_poly_nterms( resph ) = nterms - 1;
		}

		return m_poly_handle_to_poly( resph );
	}

	/* no constant term */
	/* insert acoefft */

	m_poly_create_empty( &resph, m_poly_princvar( aph ), nterms + 1 );

	m_poly_expt( resph, 0 ) = 0;
	m_poly_coefft( resph, 0 ) = integer_incref( acoefft );

	/* copy remaining terms */

	for ( atermno = ( nterms - 1 ); atermno >= 0; atermno-- )
	{
		acoefft = m_poly_coefft( aph, atermno );
		m_poly_coefft( resph, atermno+1 ) = m_modpoly_incref( acoefft );
		m_poly_expt( resph, atermno+1 ) = m_poly_expt( aph, atermno );
	}

	m_poly_nterms( resph ) = nterms + 1;

	return m_poly_handle_to_poly( resph );
}

#endif
