#include "modint.e"

integer_big
modint_add_f WITH_3_ARGS(
	integer_big,	mint,
	integer_big,	aint,
	integer_big,	bint
)
/*
** modint_add_f : modular integer sum
** functional version used by modint_add() macro.
** mint: positive integer
** aint, bint are elements of Zmint.
** returns aint + bint
*/
{
	block_declarations;
	integer_big	resint;
	integer_big	temp;

	if ( integer_is_single( mint ) )
	{
		resint = aint + bint;
		return (( resint >= mint ) ? resint - mint : resint );
	}

	resint = integer_add( aint, bint );	

	if ( integer_compare( resint, mint ) >= 0 )	
	{
		temp = resint;
		resint = integer_subtract( resint, mint );
		integer_delref( temp );
	}

	return( resint );
}
