#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "dyn_arr.h"
	
void 
mat_ring_det_sub WITH_3_ARGS(
	t_handle, cring,
	matrix, a,
	t_int *,	result
)
/*
 * to find the determinant of a
 */
{
	matrix	adash;
	dyn_arr_handle	collist; /* store the column number activated */
	t_int 			colindex;
	dyn_arr_handle	subcollist; /* store the column number in sub-matrix */
	t_int 			subcolindex;
	/* 
	 * if column i is activated then checklist(i - 1)
	 * is 1 is activated or else it is 0 
	 */
	dyn_arr_handle	checklist; 
	/*
	 * the list for storing the determinant temporary
	 */
	dyn_arr_handle	detlist;
	t_int				nrow;
	t_int				ncol;
	t_int				rowlevel;
	Logical			upward;
	t_int				temp1;
	t_int				temp2;
	t_int				det;
	t_int				col;
	t_int				i;
	t_int				detindex;
	t_int				sign;
	t_ring_elt		(*ringmult)();
	t_ring_elt		(*ringadd)();
	t_ring_elt		(*ringsubtract)();
	t_ring_elt		minus1;
	t_ring_elt		one;
	
	adash = 0;
	nrow = mat_row(a);
	ncol = mat_col(a);

	/*
	 * check whether a is square matrix
	 */

	if (nrow != ncol)
		error_internal("Non-square matrix is found in mat_ring_det_sub");
		
	/* 
	 * unpack a to adash
	 */

	ringmult = ring_multiplication(cring);
	ringadd = ring_addition(cring);
	ringsubtract = ring_subtraction(cring);
	mat_create_unpkd(cring, a, adash, nrow, ncol);

	if (nrow == 1)
	{
		/*
		 * if the matrix is 1 by 1
		 */
		*result = ring_elt_incref(cring, mat_elt(adash, 1, 1));
		mat_free_unpkd(a, adash);
		return;
	}
	else if (nrow == 2)
	{
		/*
		 * if the matrix is 2 by 2
		 */
		temp1 = (*ringmult)(cring, mat_elt(adash, 1, 1), mat_elt(adash, 2, 2));
		temp2 = (*ringmult)(cring, mat_elt(adash, 1, 2), mat_elt(adash, 2, 1));
		*result = (*ringsubtract)(cring, temp1, temp2);
		ring_elt_delete(cring, &temp1);
		ring_elt_delete(cring, &temp2);
		mat_free_unpkd(a, adash);
		return;
	}

	/*
	 * the matrix's dimension is greater than 2
	 */

	one = ring_one(cring);
	minus1 = ring_minus1(cring);
	collist = dyn_arr_alloc(nrow);
	subcollist = dyn_arr_alloc(nrow);
	checklist = dyn_arr_alloc(nrow);
	detlist = dyn_arr_alloc(((nrow * (nrow - 1)) / 2) + 1);

	/*
	 * set all elements of checklist and collist to 0
	 */

	dyn_arr_set_zero(checklist, ncol);
	dyn_arr_set_zero(collist, nrow);
	dyn_arr_set_zero(subcollist, nrow);
	
	/*
	 * set initial value for subcollist, checklist, collist, rowlevel, 
	 * upward and detindex
	 */

	dyn_arr_element(checklist, 0) = 1;
	dyn_arr_element(collist, 0) = 1;
	dyn_arr_element(subcollist, 0) = 1;
	subcolindex = 0;
	colindex = 0;
	rowlevel = nrow;
	upward = TRUE;
	detindex = 0;

	/*
	 * while loop stop when rowlevel is greater than n
	 */
	while (rowlevel <= nrow)
	{
		/*
		 * if reaching the top of matrix then the submatrix should be 1 by 1
		 */
		if (rowlevel == 1)
		{
			dyn_arr_element(detlist, detindex) = ring_elt_incref(cring, mat_elt(adash, 1, dyn_arr_element(collist, colindex))); 	
			upward = FALSE;
			rowlevel++;
			dyn_arr_element(checklist, dyn_arr_element(collist, colindex) - 1) = 0;
			colindex--;
			subcolindex--;
			continue;
		}

		if (upward)
		{
			/*
			 * find the column which has not been activated yet
			 */
			for (i = 0; i < nrow; i++)
				if (!dyn_arr_element(checklist, i))
				break;
			colindex++;
			dyn_arr_element(collist, colindex) = i + 1;
			/*
			 * deactivate the column (i + 1)
			 */
			rowlevel--;
			dyn_arr_element(checklist, i) = 1;
			subcolindex++;
			dyn_arr_element(subcollist, subcolindex) = 1;
		}
		else 
		{
			if ((rowlevel + dyn_arr_element(subcollist, subcolindex)) % 2)
				sign = minus1;
			else sign = one;

			temp1 = dyn_arr_element(detlist, detindex);
			temp2 = (*ringmult)(cring, mat_elt(adash, rowlevel, dyn_arr_element(collist, colindex)), temp1);
			dyn_arr_element(detlist, detindex) = (*ringmult)(cring, temp2, sign);
			ring_elt_delete(cring, &temp1);
			ring_elt_delete(cring, &temp2);

			col = dyn_arr_element(collist, colindex);

			/*
			 * deactivate the column  stored in collist
			 */
			dyn_arr_element(checklist, dyn_arr_element(collist, colindex) - 1) = 0;

			/*
			 * find the column not being activated yet
			 */
			for (i = col; i < nrow; i++)
				if (!dyn_arr_element(checklist, i))
				break;

			/*
			 * if all columns are activated
			 */
			if (i == nrow)
			{
				for (i = 1 ; i < rowlevel; i++)
				{
					temp1 = dyn_arr_element(detlist, detindex);
					detindex--;
					temp2 = dyn_arr_element(detlist, detindex);
					dyn_arr_element(detlist, detindex) = (*ringadd)(cring, temp1, temp2);
					ring_elt_delete(cring, &temp1);
					ring_elt_delete(cring, &temp2);
				}
				colindex--;
				subcolindex--;
				rowlevel++;
				continue;
			}

			/*
			 * if there is column not being activated 
			 */
			dyn_arr_element(collist, colindex) = i + 1;
			detindex++;
			(dyn_arr_element(subcollist, subcolindex))++;
			dyn_arr_element(checklist, i) = 1;
			upward = TRUE;
		}
	}
	
	*result = dyn_arr_element(detlist, 0);
	dyn_arr_delete(&detlist);
	dyn_arr_delete(&checklist);
	dyn_arr_delete(&collist);
	dyn_arr_delete(&subcollist);
	mat_free_unpkd(a, adash);
	ring_elt_delete(cring, &one);
	ring_elt_delete(cring, &minus1);
}
