#include "defs.h"
#include "mat.h"
#include "ring.h"
#include "z.e"
#include "q.e"
#include "zm.e"
#include "poly.e"

t_void
mat_delete_entries WITH_2_ARGS(
	t_handle,		ring,
	matrix,		mat
)
/*
** Given a matrix, delete one reference count from
** each element of the matrix.
** "ring" is the coefficient ring of the matrix
*/
{
	block_declarations;
	register integer_big	modulus;
	register t_int	i;
	register t_int	ringtype;
	register t_int	num_elems;
	t_ring_elt	t;

	if ( mat_is_packed( mat ))
	{
		return;
	}

	num_elems = mat_row(mat) * mat_col(mat);
	ringtype = ring_type(ring);
	/*
	 * decrement reference counters of mat, if required
	 */
	switch (ringtype)
	{
	case RING_ZM:
			modulus = zm_modulus(ring);
			if (integer_is_single(modulus))
				break;
	case RING_Z:
			for (i = 1; i <= num_elems; i++)
				integer_delref(mat_entry(mat,i));
			break;
	case RING_Q:
			for (i = 1; i <= num_elems; i++)
				q_delref(mat_entry(mat,i));
			break;
	default:
			for (i = 1; i <= num_elems; i++)
			{
				t = mat_entry(mat, i);
				ring_elt_delete(ring, &t);
			}
	}
}

#ifdef	AUX

/*
The A/UX compiler cannot handle this as a macro, so we turn it into
a function.
*/

t_void
mat_delref_fun WITH_2_ARGS(
	t_handle, coeff_ring,
	t_handle *, mat
)
{
	if (block_has_other_refs(*mat))
		block_decref_delete(*mat);
	else
	{
		mat_delete_entries(coeff_ring, *mat);
		mat_delete(mat);
	}
	*mat = 0;
}

#endif	/* AUX */
