/*  inthdl_compare.c
*/

#include "defs.h"
#include "inthdl.e"
#include "intbig.h"

t_int
inthdl_compare WITH_2_ARGS(
    inthdl_handle, a,
    inthdl_handle, b
)
/*
Return -1, 0, or 1 according as the big integer a is numerically less than,
equal to, or greater than the big integer b, respectively.
*/
{
    inthdl_sign			asign, bsign;
    inthdl_length		alen, blen;
    register t_int	*p, *q, diff;

    if (a == b)
	return 0;

    asign = intbig_sign(a);
    bsign = intbig_sign(b);

    if (bsign == 0)
	return asign;

    if (asign != bsign)
	return (asign < bsign)? -1: 1;

    alen = intbig_curr_size(a);
    blen = intbig_curr_size(b);

    if (alen < blen)
	/*  b has greater absolute value: b negative implies a > b  */
	return -bsign;

    if (alen > blen)
	/*  a has greater absolute value: a negative implies a < b  */
	return asign;

    /*
    Lengths are equal: find most significant differing digits
    */

    if (alen == 0)
	return 0;

    p = intbig_dig0_ptr(a) + alen;
    q = intbig_dig0_ptr(b) + blen;

    while (alen-- > 0)
	if (*--p != *--q)
	    break;

    diff = *p - *q;
    return (diff < 0)? -asign: asign * (diff > 0);
}
