#include "defs.h"
#include "integer.e"
#include "dyn_arr.e"
#include "dyn_arr.h"
#include "faclst.e"
#include "faclst.h"

/* *************************** SQUAREFREE *********************** */

integer_small 
integer_squarefree  WITH_6_ARGS(
integer_big,  	n,
faclst *,	n_facts,
integer_big *, 	x,
faclst *,	x_facts,
integer_big *, 	y,
faclst *,	y_facts
)       
/* 
 *   Tries to factor n.
 *   Returns 1 if successful.        
 *   Returns 0 if unsuccessful.
 *   Find x, y such that n = x.y^2 with x squarefree.
 *   Pointer arguments with value 0 will not be set.
 *   The faclsts are returned as though n is positive
 *   regardless of the sign of n. 
 */
{
	block_declarations;
	integer_big		m;
	faclst			a_factors, b_factors; 
	faclst			m_factors; 
	dyn_arr_handle          remainders;
	integer_small		nfacts, i;    
	integer_small		expt_i;
	integer_big		prime_i;
	integer_big		big_a, big_b;
	integer_big		temp1, temp2;
	integer_small		negate;
	
	m = integer_incref(n);

	/* If m == 0 : unsuccessful. */
	if (!m) 
		return 0;

	/* If m < 0 , negate m and make sure that the squarefree part is 
	 * negative.
	 */
	if (integer_sign(m) < 0)
	{
		temp1 = m;
		m = integer_negate(temp1);
		negate = 1;
		integer_delref(temp1);
	}
	else
		negate = 0;
	
	/* Now, factorise m.   */   
	integer_lst_factorise( m, &m_factors, &remainders, 
			10, 1000, 1023, 10, 500, 3, 100, m, TRUE );

	if (remainders)
	{
		faclst_delete( &m_factors );
		dyn_int_arr_delete( &remainders );
		integer_delref(m);
		return 0; /* Couldn't factor argument. */
	}
	nfacts = faclst_num_prime( m_factors );
	
                                           
	/* Now write m = A^2.B with B square free. */
	a_factors = faclst_alloc(0);
	b_factors = faclst_alloc(0);
        big_a = 1;
	big_b = 1;

	for(i = 0; i < nfacts; i++)
	{
		expt_i = faclst_expon(m_factors, i);
		prime_i = faclst_prime(m_factors, i);

		if (expt_i % 2) 
		{              
			if (expt_i > 1)
			{
				i_put_prime_in_factors(a_factors, 
					prime_i, (expt_i-1)/2);
				big_a = integer_mult(temp1 = big_a, 
					temp2 = integer_power(prime_i, 
						(expt_i-1)/2));
 				integer_delref(temp1);
 				integer_delref(temp2);
 			}       

			i_put_prime_in_factors(b_factors, prime_i, 1);
			big_b = integer_mult(temp1 = big_b, prime_i);
			integer_delref(temp1);
		}
		else
		{
			i_put_prime_in_factors(a_factors, prime_i, expt_i/2);
			big_a = integer_mult(temp1 = big_a, 
				temp2 = integer_power(prime_i, expt_i/2));
			integer_delref(temp1);
			integer_delref(temp2);
		}

	}	
		
	if (n_facts)
		*n_facts = m_factors;
	else 
		faclst_delete(&m_factors);
	
	/* Squarefree part. */
	if (x)
	{
		if (negate)
		{
			*x = integer_negate(big_b);
			integer_delref(big_b);
		}
		else
			*x = big_b;
	}
	else
		integer_delref(big_b);

	if (x_facts)
		*x_facts = b_factors;
	else 
		faclst_delete(&b_factors);

	/* Square part. */
	if (y)
		*y = big_a;
	else
		integer_delref(big_a);

	if (y_facts)
		*y_facts = a_factors;
	else 
		faclst_delete(&a_factors);

	integer_delref(m);
	return 1;
}
