/*  integer_gcd.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_gcd	WITH_2_ARGS(
    integer_big,    a,
    integer_big,    b
)
/*
Returns the greatest common divisor of the two arguments. Note that
gcd(a,0) = abs(a).
*/
{
    integer_big		gcd;

    DEBUG_INTEGER_2("+integer_gcd", a, b);

    if (integer_sign(a) == 0)
	gcd = integer_abs(b);
    else if (integer_sign(b) == 0)
	gcd = integer_abs(a);

    else if (integer_is_single(a) && integer_is_single(b))
    {
	register t_int	c;

	if (a < 0)
	    a = -a;

	if (b < 0)
	    b = -b;

	while ((c = a % b) != 0)
	{
	    a = b;
	    b = c;
	}

	gcd = b;
    }
    else
    {
	inthdl_sign		asign, bsign;
	inthdl_handle		ahdl, bhdl, result;
	inthdl_length		alen, blen;

	/*
	at least one of a and b is infinite-precision: convert the
	other operand to multi-precision if necessary; also take
	absolute values
	*/

	if (integer_is_single(a))
	    ahdl = inthdl_buf_alloc_1(a < 0 ? -a : a);
	else
	{
	    /*
	    If a is negative, temporarily set a to be positive.
	    */

	    ahdl = inthdl_big_to_handle(a);
	    if ((asign = intbig_sign(ahdl)) < 0)
		intbig_sign(ahdl) = 1;
	}

	if (integer_is_single(b))
	    bhdl = inthdl_buf_alloc_1(b < 0 ? -b : b);
	else
	{
	    bhdl = inthdl_big_to_handle(b);
	    if ((bsign = intbig_sign(bhdl)) < 0)
		intbig_sign(bhdl) = 1;
	}

	alen = intbig_curr_size(ahdl);
	blen = intbig_curr_size(bhdl);
	result = inthdl_buf_alloc(alen > blen ? alen : blen);
    
	inthdl_gcd(ahdl, bhdl, result);

	if (integer_is_single(a))
	    inthdl_buf_delete(ahdl);
	else
	    intbig_sign(ahdl) = asign;

	if (integer_is_single(b))
	    inthdl_buf_delete(bhdl);
	else
	    intbig_sign(bhdl) = bsign;

	gcd = inthdl_standardize(result);
    }

    DEBUG_INTEGER_1("-integer_gcd", gcd);

    return gcd;
}
