
#include "defs.h"
#include "integer.e"

/*
** maximum length (plus one) of a number in decimal digits. Any longer than
** this will cause havoc.
*/
#define STR_MAX 2048

integer_big
integer_double_to_int WITH_1_ARG(
    double,    d
)
/*
** takes a double precision number, rounds it off, and returns the
** arbritrary precision integer to which it evaluates
*/
{
    block_declarations;

    char             str[STR_MAX];
    char             *s;
    t_int    i;
    Logical          negative;
    Logical          roundup;
    integer_big      temp;
    integer_big      temp2;
    integer_big      val;
    t_handle           cont;

    sprintf( str, "%0.15f", d );

    /*
    ** test for a minus sign at the beginning
    */

    if ( str[0] == '-' )
    {
	negative = TRUE;
	s = str+1;
    }
    else
    {
	negative = FALSE;
	s = str;
    }

    /*
    ** find the decimal point, calculate if a round up is appropriate
    */

    for ( i=0; s[i] != '\0' && s[i] != '.'; ++i )
    {
    }

    roundup = FALSE;

    if ( s[i] == '.' )
    {
	s[i] = '\0';
	if ( s[i+1] >= '5' )
	{
	    roundup = TRUE;
	}
    }

    /*
    ** read in each character separately, build up the integer
    */

    cont = integer_build_first( s[0] - '0' );

    for ( i=1; s[i] != '\0'; ++i )
    {
	integer_build_next( cont, s[i] - '0' );
    }

    temp = integer_build_end( cont );

    /*
    ** apply the minus sign and round-up if necessary
    */

    if ( roundup )
    {
	temp2 = integer_add( temp, 1 );
	integer_delref( temp );
    }
    else
    {
	temp2 = temp;
    }

    if ( negative )
    {
	val = integer_negate( temp2 );
	integer_delref( temp2 );
    }
    else
    {
	val = temp2;
    }

    return  val;
}

