#include "defs.h"
#include "ring.h"
#include "gen_ring.h"
#ifndef KANT
#include "alg.e"
#endif

t_grf
gen_ring_init_gprim_fns(cring)
t_handle	cring;
{
	t_grf		cring_fns;
	t_ring_common	*cringp;

	
	cringp = ring_access(cring);
	if (cringp->gring_ptr != NP)
		return cringp->gring_ptr;
	
	switch (ring_type(cring))
	{
		case RING_Z :
			cringp->gring_ptr = cring_fns = &z_gring_fns;
			break;
		
		case RING_Q :
			cringp->gring_ptr = cring_fns = &q_gring_fns;
			break;

		case RING_ORDER :
			cringp->gring_ptr = cring_fns = &order_gring_fns;
			break;

		case RING_ANF :
			cringp->gring_ptr = cring_fns = &anf_gring_fns;
			break;

		case RING_ZM :
			cringp->gring_ptr = cring_fns = &zm_gring_fns;
			break;

		case RING_R:
			cringp->gring_ptr = cring_fns = &real_gring_fns;
			break;

		case RING_C:
			cringp->gring_ptr = cring_fns = &comp_gring_fns;
			break;

		default:
#ifndef KANT
			cringp->gring_blk = mem_alloc(sizeof(t_gring_fns));
			cringp->gring_ptr = cring_fns = (t_grf)mem_access(cringp->gring_blk);

			cring_fns->elt_add = ALG_FIND(cring, OP_ADD);
			cring_fns->elt_coerce = alg_elt_coerce(cring);
			cring_fns->elt_delete = alg_elt_delete(cring);
			cring_fns->elt_equal = ALG_FIND(cring, OP_EQ);
			cring_fns->elt_gcd = ALG_FIND(cring, OP_GCD);
			cring_fns->elt_incref = alg_elt_incref(cring);
			cring_fns->elt_mult = ALG_FIND(cring, OP_MULT);
			cring_fns->elt_negate = ALG_FIND(cring, OP_NEGATE);
			cring_fns->elt_power = ALG_FIND(cring, OP_POWER);
			cring_fns->elt_print = alg_elt_print(cring);
			cring_fns->elt_quotrem = ALG_FIND(cring, OP_QUOTREM);
			cring_fns->elt_slash = ALG_FIND(cring, OP_SLASH);
			cring_fns->elt_subtract = ALG_FIND(cring, OP_SUBTRACT);
			cring_fns->is_zero = ALG_FIND(cring, OP_IS_ZERO);
			cring_fns->is_one = ALG_FIND(cring, OP_IS_ONE);
			cring_fns->is_minus_one = ALG_FIND(cring, OP_IS_MINUS_ONE);

#if 0
			/* particular functions will exist depending on the type. */
			ASSERT(cring_fns->elt_add );
			ASSERT(cring_fns->elt_coerce);
			ASSERT(cring_fns->elt_delete);
			ASSERT(cring_fns->elt_equal );
			ASSERT(cring_fns->elt_gcd );
			ASSERT(cring_fns->elt_incref );
			ASSERT(cring_fns->elt_mult );
			ASSERT(cring_fns->elt_negate );
			ASSERT(cring_fns->elt_power );
			ASSERT(cring_fns->elt_print );
			ASSERT(cring_fns->elt_quotrem );
			ASSERT(cring_fns->elt_slash );
			ASSERT(cring_fns->elt_subtract );
			ASSERT(cring_fns->is_zero );
			ASSERT(cring_fns->is_one );
			ASSERT(cring_fns->is_minus_one );
#endif /* 0 */
#else /* KANT */
			DIE();
#endif /* KANT */
	}
	return cring_fns;
}



t_void gen_ring_biff_gprim_fns(cring)
t_handle	cring;
{
	t_ring_common 	*cringp;

	cringp = ring_access(cring);
	if (cringp->gring_blk != NH)
	{
		mem_delete_h(cringp->gring_blk);
		cringp->gring_blk = NH;
		cringp->gring_ptr = NP;
	}
}
