#include "defs.h"
#include "integer.e"
#include "dyn_arr.e"
#include "dyn_arr.h"

void
dyn_int_arr_delete WITH_1_ARG(
	dyn_arr_handle *,    ph
)
/*
** delete a dynamic integer array, thus deleting a reference to each
** element of the array. Elements are assumed to be either single or
** multiple precision integers.
*/
{
    block_declarations;

    dyn_arr_length    i;

    i = dyn_arr_curr_length( *ph );

    while ( --i >= 0 )
        integer_delref( dyn_arr_element( *ph, i ));

    mem_delete_hptr( ph );
}
