#include "defs.h"
#ifndef KANT
#include "alg.e"
#endif
#include "ring.h"
#include "dyn_arr.h"

void
dyn_arr_ring_elt_delete WITH_2_ARGS(
	t_handle,			ring,
	dyn_arr_handle *,	ph
)
/*
** Delete an array of ring elements.
*/
{
    dyn_arr_length	i;
    t_ring_elt		temp;

    if ( ! block_has_other_refs( *ph ))
    {
	i = dyn_arr_curr_length( *ph );

	while ( --i >= 0 )
	{
	    temp = dyn_arr_element( *ph, i );
	    ALG_ELT_DELETE( ring, temp );
	}
    }

    block_decref_delete( *ph );
    *ph = 0;
}
