#include "mem.h"

#ifdef USE_SBRK

/*
If we are using SBRK under UNIX, we actually supply our own version of
malloc(), etc.
*/

void *malloc(n)
int n;
{
    t_ptr	bp;

    if (!memi_done_init)
	mem_init();

    STATS(memi_stats_malloc++);
    n = BYTES_TO_PTRS(n) + HEADER_SIZE;
    bp = memi_get_block(n);
    if (!bp)
	return 0;

    BLOCK_HANDLE(bp) = P_MALLOC;

    return bp;
}

void free(bp)
void	*bp;
{
    ASSERT(memi_done_init);
    STATS(memi_stats_free++);
    memi_free_block_coalesce(bp);
}

void cfree(bp)
void	*bp;
{
    ASSERT(memi_done_init);
    STATS(memi_stats_free++);
    memi_free_block_coalesce(bp);
}

void *calloc(n, m)
int n, m;
{
    t_ptr bp, rp, ep;
    t_len s;

    s = n * m;
    bp = malloc(s);
    rp = bp;
    ep = bp + BYTES_TO_PTRS(s);
    while (bp < ep)
	DEREF(bp++) = NULL;

    return rp;
}

void *realloc(op, n)
void	*op;
t_len	n;
{
    t_ptr	bp, newp;
    t_len	oldsize, newsize;

    ASSERT(memi_done_init);
    STATS(memi_stats_realloc++);
    bp = op;
    newsize = BYTES_TO_PTRS(n) + HEADER_SIZE;
    oldsize = NEXT_BLOCK(bp) - bp;

    if (newsize > oldsize)
    {
	newp = memi_extend_block(bp, newsize, FALSE);
	if (newp != bp)
	    BLOCK_HANDLE(newp) = P_MALLOC;
    }
    else
    {
	newp = bp;
	if (newsize < oldsize)
	    memi_reduce_block(bp);
    }

    return newp;
}
#endif

t_void *f_mem_malloc FL1(n)
t_int n;
{
    t_ptr	bp;

    if (!memi_done_init)
	mem_init();

    STATS(memi_stats_malloc++);
    TRACE("mem_malloc", 0, n);

    bp = memi_get_block(BYTES_TO_PTRS(n) + HEADER_SIZE);

    BLOCK_HANDLE(bp) = P_MEM_MALLOC;
    ASSIGN_CALLER(bp);
    ASSIGN_MARK(bp);

    return bp;
}

t_void mem_free(bp)
t_void	*bp;
{
    ASSERT(memi_done_init);
    STATS(memi_stats_free++);
    memi_free_block_coalesce(bp);
}

t_void *f_mem_calloc FL2(m, n)
t_int m, n;
{
    t_ptr	bp, xp, ep;
    t_int	p;

    p = m * n;
    bp = f_mem_malloc CALL_FL1(p);

    ep = NEXT_BLOCK(bp) - HEADER_SIZE;
    xp = bp;
    while (xp < ep)
	DEREF(xp++) = 0;

    return bp;
}

t_void *f_mem_realloc FL2(up, n)
t_void	*up;
t_len	n;
{
    t_ptr	newp, bp;
    t_len	oldsize, newsize;

    TRACE_ALLOCS_LOCAL(char *name; t_int line_num);
    MARKS_LOCAL(t_int mark);

    bp = (t_ptr)up;
    newsize = BYTES_TO_PTRS(n) + HEADER_SIZE;
    oldsize = NEXT_BLOCK(bp) - bp;

    if (newsize > oldsize)
    {
	IF_TRACE_ALLOCS(
	    name = BLOCK_FILE_NAME(bp);
	    line_num = BLOCK_LINE_NUM(bp);
	)
	IF_USE_MARKS(
	    mark = BLOCK_MARK(bp);
	)

	newp = memi_extend_block(bp, newsize, FALSE);

	if (newp != bp)
	{
	    IF_TRACE_ALLOCS(
		BLOCK_FILE_NAME(newp) = name;
		BLOCK_LINE_NUM(newp) = line_num
	    )
	    IF_USE_MARKS(
		BLOCK_MARK(newp) = mark;
	    )
	    BLOCK_HANDLE(newp) = P_MEM_MALLOC;
	}
    }
    else
    {
	newp = bp;
	if (newsize < oldsize)
	    memi_reduce_block(bp);
    }

    return newp;
}

t_void *f_mem_malloc_aligned FL2(alignment, n)
t_int	alignment, n;
/*
Return a block which is guaranteed to have its address a multiple
of the given alignment.
*/
{
    t_ptr	bp, newp;
    t_int	newi, mod;

    STATS(memi_stats_alloc++);
    CHECK("mem_malloc_aligned", n >= MIN_USER_SIZE, n);

    bp = memi_get_block(BYTES_TO_PTRS(n + alignment) + 2 * HEADER_SIZE + 1);
    if ((t_int)bp % alignment)
    {
	newp = bp + HEADER_SIZE + 1;
	newi = (t_int)newp;
	mod = newi % alignment;
	if (mod)
	    newp = (t_ptr)(newi + (alignment - mod));

	NEXT_BLOCK(newp) = NEXT_BLOCK(bp);
	PREV_BLOCK(NEXT_BLOCK(bp)) = newp;

	NEXT_BLOCK(bp) = newp;
	PREV_BLOCK(newp) = bp;

	memi_free_block(bp);
	bp = newp;
    }

    BLOCK_HANDLE(bp) = P_MEM_MALLOC;
    ASSIGN_CALLER(bp);
    ASSIGN_MARK(bp);

    return bp;
}

t_void *f_mem_biffable_malloc FL1(n)
t_int n;
{
    t_ptr	bp;

    n = BYTES_TO_PTRS(n) + HEADER_SIZE;
    bp = memi_get_block(n);

    BLOCK_HANDLE(bp) = P_BIFFABLE_MALLOC;
    ASSIGN_CALLER(bp);
    ASSIGN_MARK(bp);

    return bp;
}

t_void mem_biffable_free(bp)
void	*bp;
{
    memi_free_block_coalesce(bp);
}

t_void mem_biff_biffables()
/*
Biffs all biffably-mallocced blocks.
*/
{
    t_ptr	bp;

    bp = memi_base_mem;
    while (bp < memi_high_mem)
    {
	if (BLOCK_HANDLE(bp) == P_BIFFABLE_MALLOC)
	    memi_free_block_coalesce(bp);
	bp = NEXT_BLOCK(bp);
    }
}
