/******************************************************************************
  order_reals_set.c
******************************************************************************/
 
#include "kant.h"
#include "real.e"
#include "anf.h"
#include "conv.e"

void
order_reals_set WITH_2_ARGS(
	order,		ord,
	integer_small,	prec
)
/*******************************************************************************
 
Description:
 
        (Re-)Sets the precision for real computations in an order.
        This routine has to be called for an order if the user intends
        to do real computations with the order elements.
        This routine not necessarily needs to be called: If no real field
        was set and if order_reals_create is called the default precision 
        will be set to 20.
        If you use the KANT V1-interface routine order_read_v1 or order_read
        the real field can be set by using PRECIS.
  
Calling sequence:
 
	order_reals_set(ord, prec)
 
      	order         ord      = t_handle of order 
      	integer_small prec     = precision wanted
      
 
History:
 
	92-03-31 JS	output if anf_print_level > 1
	92-03-19 JS	renaming into order_reals_*
	91-10-11 JS     minor changes
	91-10-01 JS     written
  
*******************************************************************************/
{
	block_declarations;
 
	t_handle		reals;
	t_real		two;
         
/*
    Reset?
*/                                
 
	order_reals_delete(ord); 
 
/*
    New values
*/         
        if (anf_print_level > 1)
                printf("Real precision of order %d set to %d.\n", ord, prec);

	reals = real_str_create(prec);
	order_reals(ord) = reals;
 
	two = conv_int_to_real(reals, 2);
	order_sqrt_2(ord) = real_sqrt(reals, two);
   
	real_delete(&two);
 
	return;
}
