/******************************************************************************
  order_reals_copy.c
******************************************************************************/
#include "kant.h"
#include "real.e"
#include "anf.h"

void
order_reals_copy WITH_2_ARGS(
	order,		ord1,
	order,		ord2
)
/*******************************************************************************
 
Description:

	Copies the real field used by ord1 into the structure of ord2.
	This is used by order_reals_create.
        So calling this routine instead of order_reals_set sets the
        precision of the subsequent real computations in ord2 to the
        same precision as in ord1.
 
   
Calling sequence:
 
	order_reals_copy(ord1, ord2);

	order	ord1	= order from which the real field is taken
	order	ord2	= target order
   
 
History:
 
	92-03-19 JS	renaming into order_reals_*
	91-10-11 JS	first version
 
*******************************************************************************/
{
	block_declarations;
 
	t_handle		reals;
	t_real		two;
         
/*
    Reset
*/
	order_reals_delete(ord2); 
 
/*
    New values
*/
	reals = order_reals(ord1);
 
	order_reals(ord2)  = ring_incref(reals);
 
	order_sqrt_2(ord2) = real_incref(order_sqrt_2(ord1));
   
	return;
}
