/******************************************************************************
  order_class_group_calc.c
******************************************************************************/
 
#include "kant.h" 
 
#define IDBOUNDMIN 60
#define IDBOUNDMAX 800
#define RELMIN     11
#define IDMIN      3
 
t_void
order_class_group_calc WITH_1_ARG (
	order,		ord
)
/*******************************************************************************
                   
Description:	
 
	Computes the class group structure of ord. Here ord should
	be the maximal order of a number field (this will not be checked).
 
	The technique used is the "relation method". Since relations might have
	already been computed by a previous program it is first checked
	whether the class group can be derivated from this data. If not,
	new relations are computed and evaluated. If that still does not work
	everything is computed from scratch, including the factor basis.
 
	Attention:	This function is preliminary. It does not care for
			using the correct Minkowski/Zimmert/Bach bound
 
  
Calling sequence:  

	order_class_group_calc(ord)

	ord	=	t_handle of order
 
  
History:
 
	93-02-17 KW	second version
	92-09-01 JS     first version
 
*******************************************************************************/
{
	block_declarations;
 
        integer_big     t2, idbound, temp, mink, bach;
        integer_small   sign, numid, r, numrel, numrel1;

/*
   Is the structure known already?
*/

        if (order_class_group_structure_known(ord)) return;
 
/*
   Do we already have a few relations? If they are at least RELMIN
   and if the factor basis consists at least IDMIN ideals we assume
   that we have a chance.
*/   
 
        numid  = (order_fac_basis(ord))
                 ? order_fac_basis_ideals_count(ord)
                 : 0;
        numrel = order_relation_count(ord);    

	r = order_r(ord);

        if (numid >= IDMIN)
        {
        	if (numrel < RELMIN || numrel <= numid)    
	        {
	                order_relation_delete(ord);
		        numrel1 = (int) ((10 * r) / numid) + 2;
		        if (order_torsion_rank(ord) > 2) numrel1 *= 2;
	        	t2 = 0;
		        order_relations_find(ord, t2, numrel1);
	                order_relation_eval_class_group(ord);
                }
                else
                {
	                order_relation_eval_class_group(ord);
                }
	        if (order_class_group_structure_known(ord)) return;
        }
/*
    We do everything from scratch.
*/
        order_fac_basis_delete(ord);
        order_relation_delete(ord);
 
/*
   Getting an appropriate bound for the factor basis
*/
	bach    = order_bach_bound(ord);
	mink    = order_minkowski_bound(ord);
	integer_root(mink, 2, &idbound, &sign);
                       
	if (integer_compare(idbound, IDBOUNDMIN) < 0)
	{
	        temp    = idbound;
		idbound = IDBOUNDMIN;
		integer_delref(temp);
	}
        if (integer_compare(idbound, IDBOUNDMAX) > 0)
	{
	        temp    = idbound;
		idbound = IDBOUNDMAX;
		integer_delref(temp);
	}

	order_fac_basis_create(ord, idbound);

	r = order_r(ord);
	numid = order_fac_basis_ideals_count(ord);
	 
/*	numrel = (int) ((10 * r) / numid) + 2;  */
	numrel = (int) ((10 * r) / numid) + 4;  
	if (order_torsion_rank(ord) > 2) numrel *= 2;
	 
        t2 = 0;
	order_relations_find(ord, t2, numrel);

	integer_delref(t2);
	integer_delref(mink);
	integer_delref(bach);
	integer_delref(idbound);
 
        order_relation_eval_class_group(ord);
        
        return;                           
}
