/******************************************************************************
  mat_ring_write.c
******************************************************************************/
 
#include "kant.h" 
#include "real.e"
#include "mat.h"

void 
mat_ring_write WITH_2_ARGS(
	t_handle,	cring,
	matrix, mat
)
/*******************************************************************************
 
Description: 
 
 	Generic matrix output function.
        Supports matrices over reals, orders and Z.
               
 
Calling sequence: 
	
	mat_ring_write(R, mat);
                               
	t_handle		R      = t_handle of the ring
        amatrix		mat    = matrix to print

  
History:

 	92-03-01 KW 	first version
 
*******************************************************************************/
{
	block_declarations;

	switch (ring_type(cring))
	{
	case RING_Z	: 
	case RING_ORDER	: mat_anf_write(cring,mat);
			  break;
	case RING_R	: mat_real_write(cring,mat);
			  break;
	default 	: error_internal("mat_write: unknown type\n");
	}
}
