/******************************************************************************
  mat_ring_col_to_vector.c
******************************************************************************/
#include "kant.h" 
#include "vector.h" 
#include "anf.h"     

vector
mat_ring_col_to_vector WITH_3_ARGS(
	t_handle,		cring,
	matrix,		mat,
	integer_small,	col
)
/******************************************************************************
 
Description:	Extracts a specified column of the passed matrix as a vector.
 
Calling sequence:
 
	vec = mat_ring_col_to_vector(cring,mat,col)

	vector		vec		= t_handle of vector
	ring		cring		= t_handle of the mat-entries ring
	matrix		mat		= t_handle of matrix
	integer_small	col		= number of column
 
History:
 
	92-01-09 KW    written
 
******************************************************************************/
{
	block_declarations;

	vector		v;
	integer_small	i,row;

	if (mat_col(mat) < col)
		error_internal("matrix has less columns than specified.");

	row = mat_row(mat);

	v = vec_new(row);
	
	for(i=1;i<=row;i++)
	{
		vec_entry(v,i) = ring_elt_incref(cring,mat_elt(mat,i,col));
	}

	return(v);
}
