/******************************************************************************
  mat_ring_col_append.c
******************************************************************************/
#include "kant.h"

matrix
mat_ring_col_append WITH_3_ARGS (
	t_handle,	cring,
	matrix,		mat,
	vector,		vec
)
/******************************************************************************
 
Description:	Enlarges a matrix by a column.
 
Calling sequence:  

	result = mat_ring_col_append(cring,mat,vec)

	t_handle	cring	: the ring of the coefficients
	matrix		mat	: the matrix to be enlarged
	vector	v	ec	: the column to be appended

History:
 
	92-06-25 KW	minor changes
	92-06-03 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,j;
	integer_small	row,col;
	matrix		result;

	if (mat)
	{
		row = mat_row(mat);
		col = mat_col(mat);
		if (row != vec_length(vec))
			error_internal("mat_ring_col_append: incompatible dimensions");
	}
	else
	{
		row = vec_length(vec);
		col = 0;
	}

	result = mat_new(row,col+1);
	for (i=1;i<=row;i++)
	{
		for (j=1;j<=col;j++)
		{
			mat_elt(result,i,j) = ring_elt_incref(cring,mat_elt(mat,i,j));
		}
		mat_elt(result,i,col+1) = ring_elt_incref(cring,vec_entry(vec,i));
	}

	return(result);
}
