/******************************************************************************
  lat_elt_negate.c
******************************************************************************/
#include "kant.h"
#include "lattice.h"

lat_elt
lat_elt_negate WITH_2_ARGS (
	lattice,	lat,
	lat_elt,	elt
)
/******************************************************************************
 
Description:	Negates a lattice element.
 
Calling sequence:
 
	neg_elt = lat_elt_negate(lat,elt)

	lat_elt		neg_elt		= t_handle of lattice element
	lattice		lat		= t_handle of lattice		
	lat_elt		elt		= t_handle of lattice element
					  to be negated
 
History:

	92-03-18 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,rank;
	lat_elt		eltn;

	rank = lat_rank(lat);
	lat_elt_alloc(eltn, rank);

	for (i=1;i<=rank;i++)
	{
		lat_elt_coef(eltn,i) = integer_negate(lat_elt_coef(elt,i));
	}
	
	return(eltn);
}
