/******************************************************************************
  lat_delete.c
******************************************************************************/
#include "kant.h"
#include "mat.e"
#include "lattice.h"  


void
lat_delete WITH_1_ARG (
	lattice*,	lat
)

/******************************************************************************
 
Description:	Deletes a lattice. The lattice is delreffed. If there are
		no other references it is deleted completely.
 
Calling sequence:
 
	lat_delete(&lat)

	lattice		lat	= t_handle of lattice to be deleted
 
History:
 
	92-05-12 JS    deleting lat_chol_ring
	92-02-13 KW    written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i;

	if (block_ref_count(*lat) == 1)
	{
		for (i=1;i<=lat_succ_min_count(*lat);i++)
		{
			ring_elt_delete(lat_gram_ring(*lat),&lat_succ_min(*lat,i));
		}
		if (lat_succ_mins(*lat)) dyn_arr_delete(&lat_succ_mins(*lat));

		for (i=1;i<=lat_succ_min_vec_count(*lat);i++)
		{
			lat_elt_delete(*lat,&lat_succ_min_vec(*lat,i));
		}
		if (lat_succ_mins_vecs(*lat)) dyn_arr_delete(&lat_succ_mins_vecs(*lat));

		if (lat_basis_known(*lat))
		{
			mat_delref(lat_basis_ring(*lat),&lat_basis(*lat));
			ring_delete(&lat_basis_ring(*lat));
		}
		if (lat_gram_known(*lat))
		{
			mat_delref(lat_gram_ring(*lat),&lat_gram(*lat));
			ring_delete(&lat_gram_ring(*lat));
		}
		if (lat_chol_known(*lat))
		{
			mat_delref(lat_chol_ring(*lat),&lat_chol(*lat));
			dmat_delete(&lat_double_chol(*lat));
		}
		if (lat_chol_ring(*lat)) 
		{
			ring_delete(&lat_chol_ring(*lat));
		}

		if (lat_disc_known(*lat))
		{
			ring_elt_delete(lat_disc_ring(*lat),&lat_disc(*lat));
			ring_delete(&lat_disc_ring(*lat));    
		}
	}        

	block_decref_delete(*lat);

	*lat = MEM_NH;
}
