/******************************************************************************
  lat_chol_calc.c
******************************************************************************/
#include "kant.h"
#include "conv.e"
#include "mat.h"
#include "lattice.h"

void
lat_chol_calc WITH_1_ARG(
	lattice,	lat
)
/******************************************************************************
 
Description:	Computes the positive quadratic form from the gram matrix
         	of the passed lattice. If chol_ring of the passed lattice
		is not known the presicion is set up to the default value
		defined in routine mat_ring_gram_chol.

		The result is stored inside the lattice structure.

Calling sequence:
 
	lat_chol_calc(lat)         

	lattice		lat	= t_handle of lattice
 
History:
 
	92-02-28 KW    minor changes 
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,j;   

	if (lat_chol_known(lat)) return;
	if (!lat_gram_known(lat)) lat_gram_calc(lat);

	if (lat_chol_ring(lat) == MEM_NH)
	{   
		if (lat_basis_ring(lat) && (ring_type(lat_basis_ring(lat)) == RING_R) ) 
                {  
                     lat_chol_ring(lat) = ring_incref(lat_basis_ring(lat));  
                }
                else
                {
		if (lat_gram_ring(lat) && (ring_type(lat_gram_ring(lat)) == RING_R) )   
                     lat_chol_ring(lat) = ring_incref(lat_gram_ring(lat));
                else 
                error_internal("lat_chol_calc: Fuck off, no real rings !!");
                }                                                      
	}


	lat_chol(lat)
	= mat_ring_gram_chol(lat_gram_ring(lat),lat_gram(lat),&lat_chol_ring(lat));

/*
*	For enumeration by double precision we need a double version
*	of the quadratic form.
*/
	lat_double_chol(lat) = dmat_new(lat_rank(lat),lat_rank(lat));
	for(i=1;i<=lat_rank(lat);i++)
	{
		for (j=1;j<=lat_rank(lat);j++)
		{
			dmat_elt(lat_double_chol(lat),i,j)
			= conv_real_to_double(lat_chol_ring(lat),mat_elt(lat_chol(lat),i,j));
		}
	}		
}
