#ifdef KANT
/******************************************************************************
  kant_start.c
******************************************************************************/
 
#include "kant.h"
#include "globals.e"

t_void callback(); 
 
void
kant_start()
/*******************************************************************************
 
Description:
 
	Initializes platform environment for KANT programs.
 
	This routine is to be called once by every main program.
	It initializes the workspace and the real package.
 
 
Calling sequence (example!):
	kant_start();
 
History:
 
	92-09-08 JS/AKS	BH to MEM
	92-06-15 JS	creating (and deleting) Z and Z/2Z
	91-10-01 JS	first version
 
*******************************************************************************/
{      
        t_handle  Z, Zm;
 
	mem_init();
	mem_set_callback(callback);

	/* limit in bytes: 0 == no limit */
	mem_set_limit(0);

	/* number of bytes to extend process by when run out of room */
	mem_set_extension_size(100000);

	real_start(MP_TRUNC, callback); 

	structure_z = z_str_create();
	structure_q = q_str_create();
	structure_pring_z = poly_str_create(structure_z, 1);
	structure_pring_q = poly_str_create(structure_q, 1);
 
	return;
}
#endif
