/*******************************************************************************
 integer_read_primes.c
********************************************************************************/

#include "kant.h" 
#include "integer.e" 
#include "dyn_arr.h"  
       
extern integer_small small_primes[NSPRIMES];
                         
#define INCR 100

dyn_arr_handle    
integer_read_primes WITH_1_ARG (
	integer_big,   bound
)
/*******************************************************************************

Description:
   
    Initializes a dyn_arr with all primes < bound.  

                       
Calling sequence:
        
          list = integer_read_primes(bound)
                                                           
          integer_big     bound      : This is the upper bound for the integers.
          dyn_arr_handle  list       : the list of primes below bound.                                    
                       

History:                                 
                                                             
   JS 07.09.92    written newly using i_next_prime
   MD 20.04.92    using_disk added
   MD 20.02.92    written                                          

********************************************************************************/
{
        block_declarations;
 
	integer_big      a;       
	dyn_arr_handle   p, pold, primes;
	integer_small    i, count;
                       
	primes = dyn_arr_alloc (INCR);     
        dyn_arr_curr_length(primes) = count = 0;
                     
        p = 0;
        for (i=0; i<NSPRIMES; i++)
        {          
                p = small_primes[i];
                if (integer_compare(p, bound) < 0)
                {                                    
                        count++;
		        dyn_arr_assure_space(primes, count, INCR);
                        dyn_arr_element(primes, count-1) = p;
                        dyn_arr_curr_length(primes)      = count;
                }
                else
                {
                        return primes;
                }
        } 
 
        for (;;)
        {                         
                pold = p;
                p    = i_next_prime(pold, 0);
                if (integer_compare(p, bound) < 0)
                {                                    
                        count++;
		        dyn_arr_assure_space(primes, count, INCR);
                        dyn_arr_element(primes, count-1) = p;
                        dyn_arr_curr_length(primes)      = count;
                }                                     
                else
                {
                        return primes;
                }
        }
}

