/*******************************************************************************
  integer_prime_val_div.c 
********************************************************************************/
 
#include "kant.h" 
#include "integer.e" 

integer_small 
integer_prime_val_div WITH_2_ARGS (integer_big *,       n,
                                   integer_big  ,       p )
/*******************************************************************************

Description:                               

   Calculates the unique number v such that 
          
              v               (v+1)
             p  | n    and   p      not | n
 
   This routine also divides n by this power.


Calling sequence:
 
              v = integer_prime_val(&n, p);
                                              
              declarations are obvious!
               
 
History:  
                                                               
	92-05-05 JS	first version
                                                    
********************************************************************************/
{ 
        block_declarations;
 
	integer_small 	v;
        integer_big     temp, q, r;
 
        if (*n == 1 || *n == -1) return 0;
        
	v    = -1;                    
        r    =  0;
 
        while (!r)
        {
                integer_quot_rem(*n, p, &q, &r);
                if (!r) 
		{
			integer_delref(*n);
	                *n = q;
		}
                v++;
        }
 
        integer_delref(q);
        integer_delref(r);
 
        return v;
}
