/******************************************************************************
  integer_anf_elt_lift.c                                                           
******************************************************************************/
         
#include "kant.h"
#include "integer.e"
#include "anf.h"


anf_elt
integer_anf_elt_lift WITH_2_ARGS(
	order,		ord,
	integer_big,	a
)
/*******************************************************************************
 
Description:
 
	Expressing a referring to the basis of ord. Here the integer a will
        be "expanded", i.e. the anf_elt given back will represent a but via
        coefficients referring to the basis.
 
 
Calling sequence:
 
	alpha = integer_anf_elt_lift(ord, a);
 
      	order       ord   = t_handle of order a is to be calculated referring to
        integer_big a     = the integer
      	anf_elt     alpha = a but now referring to basis of ord
 

History:
 
	92-03-31 JS    first version

*******************************************************************************/
{
	block_declarations;
 
	anf_elt		alpha;
	integer_small	deg;
	integer_small	onepos;
	integer_small	i;
 
        onepos = order_one_position(ord);
	if (onepos <= 0) 
		error_internal("integer_anf_elt_lift: One not in basis.");

        deg = order_rel_degree(ord);
	anf_elt_alloc(alpha, deg);
/*
    all coefficients are 0, excluding the coefficient of the basis element "1"
*/	
 
        for (i=1; i<=deg; ++i) anf_elt_coef(alpha,i) = 0;
	anf_elt_coef(alpha, onepos) = integer_incref(a);
	anf_elt_den(alpha) 	    = 1;
 
	return alpha;
}
