/******************************************************************************
  anf_order_set_sig.c                                                           
******************************************************************************/
         
#include "kant.h"

void
anf_order_set_sig WITH_3_ARGS(
	t_handle,		h,
	integer_small,	r1,
	integer_small,	r2
)
/*******************************************************************************

Description: 
	
	Sets the signature parameters n, r1, r2 and r of the order resp. field
	submitted.
	The same is done for every structure "within reach", e.g. if an order
	is submitted also for the quotient field, or if a field is submitted
	for all orders in this field known to this point.
 
 
Calling sequence: 
	
	p = anf_order_set_sig(h, r1, r2)

	t_handle		h   = t_handle of the order or anf
	integer_small	r1  = number of real places
	integer_small	r2  = half number of non-real places

History:
      
        92-05-26 JS     case no order_anf given
	91-10-01 JS     first version
  
*******************************************************************************/
{
	block_declarations;
                
	order		ord;
	integer_small	cnt, i, r, n;
                                 
	r = r1 + r2 - 1;
	n = r1 + r2 + r2;
 
	if (handle_is_anf(h))
	{
		anf_abs_degree(h) = n;
		anf_r1(h) = r1;
		anf_r2(h) = r2;
		anf_r(h)  = r;
                      
		cnt = anf_order_count(h);
		for (i=1; i<=cnt; ++i)
		{
			ord = anf_order(h, i);
 
			order_abs_degree(ord) = n;
			order_r1(ord) = r1;
			order_r2(ord) = r2;
			order_r(ord)  = r;
		} 
	}
	else if (handle_is_order(h))
	{
		if (order_anf(h))
		{
			anf_order_set_sig(order_anf(h), r1, r2);
		}
		else 
		{
			order_abs_degree(h) = n;
			order_r1(h) = r1;
			order_r2(h) = r2;
			order_r(h)  = r; 
 
			if (order_basis_is_rel(h))
				anf_order_set_sig(order_suborder(h), r1, r2);
		} 
	}
			
	return;
}
