
#include "kant.h"
#include "integer.e"
#include "mat.e"
#include "anf.h"


void
anf_norm_rel WITH_4_ARGS(
	order,		ord,
	anf_elt,	alpha,
	anf_elt *,	norm,
	integer_big *,	den
)
/*******************************************************************************
 
anf_norm_rel.c
 
JS September 1991
Last modification: 26.09.91
 
Relative norm of an algebraic number
 
This routine computes the relative norm of alpha over the quotient field
of the coefficient order of ord. It computes the determinant of the 
representation matrix of alpha.
 
On exit, the anf_elt norm contains the norm (and den=1). If the
coefficient order is Z the denominator is given back in den.

 
*******************************************************************************/
{
	block_declarations;
 
	order		ordcoef;
        integer_big	denpow,	gcd, temp;
	integer_small	deg;
	matrix		mat;

         
	*den = 1;
 
/*  
    Is the order equal Z?
*/
 
	if (ring_type(ord) == RING_Z) 
	{
		*norm = integer_incref(alpha);
		return;
	}
 
	deg = order_rel_degree(ord);
 
/*  
    Trivial case 
*/
 
	if (anf_elt_is_integer(alpha)) 
	{
		*norm = integer_power(alpha, deg);
		return;
	}
 
 
/*  
    Representation matrix 
*/
 
	mat = anf_rep_mat(ord, alpha);
  
/* 
    Determinant of the representation matrix
*/

        ordcoef = order_coef_order(ord);
	*norm = mat_ring_det(ordcoef, mat);
 
/* 
    Denominator
*/
	denpow = integer_power(anf_elt_den(alpha), deg);
 
	if(ring_type(ordcoef) != RING_Z)
	{
		temp = anf_elt_den(*norm);
		anf_elt_den(*norm) = integer_mult(denpow, temp);
		integer_delref(temp);
	}
	else
	{
		if(denpow > 1)
		{
			gcd = integer_gcd(*norm, denpow);
			temp = *norm;
			*norm = integer_div(temp , gcd);
			*den  = integer_div(denpow, gcd);
			integer_delref(temp);
			integer_delref(gcd);
		}
	}
 
	integer_delref(denpow);
	mat_delref(ordcoef, &mat);
 
	return;
}
