/******************************************************************************
  anf_ideal_shortest_vector.c
******************************************************************************/
#include "kant.h"
#include "anf.h"
#include "lattice.h"  


anf_elt
anf_ideal_shortest_vector WITH_4_ARGS (
	order,		ord,
	anf_ideal,	id,
	t_logical,	prec_flag,
	t_real*,	length
)

/******************************************************************************
 
Description:	Calculates the element with smallest T2-norm
		in the passed ideal.
 
Calling sequence:
 
	alpha = anf_ideal_shortest_vector(ord,id,prec,&length)
                                  

	anf_elt		alpha	= t_handle of the element with smallest T2-norm
				  in the passed ideal
				  representation via the basis of ord)
	order		ord	= t_handle of order
	anf_ideal       id	= t_handle of ideal
	t_logical		prec	= FALSE : enumeration by double arithmetic 
				  TRUE  : enumeration by long arithmetic
	t_real		length	= T2-norm of alpha
 
History:
 
	92-03-19 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		alpha;
	lattice		lat;
	lat_enum_env	env;

	anf_ideal_lat(ord,id,&lat,&env);

	lat_chol_ring(lat) = real_incref(order_reals(ord));

    	if (prec_flag) lat_enum_precision_set_long(env);
	lat_enum_strategy_set_up(env);

	lat_enum(lat,env);
	            
	*length = real_incref(lat_enum_act_length(env));

	alpha = lat_elt_ideal_to_anf_elt(lat,lat_enum_act_coefs(env),ord,id);

	lat_enum_delete(lat,&env);	
	lat_delete(&lat);		

	return(alpha);
}
