#include "kant.h"
#include "mat.e"
#include "anf.h"

/*
 
This file contains:
 
anf_ideal_delete        
anf_ideal_2_delete         
anf_ideal_z_delete         
 
*/
 
 

void
anf_ideal_delete WITH_2_ARGS(
	order,		ord,
	anf_ideal *,	id
)
/*******************************************************************************
 
anf_ideal_delete.c
 
JS September 1991       
Last modification: 22.10.91
 
Deletes an ideal.
 
*******************************************************************************/
{       
	block_declarations;
 
	void 	anf_ideal_2_delete();
	void 	anf_ideal_z_delete();
 
	if (!block_has_other_refs(*id))
	{
		anf_ideal_2_delete(ord, *id);
		anf_ideal_z_delete(ord, *id);
	 
		integer_delref(anf_ideal_min(*id));
	}
 
	block_decref_delete(*id);

	*id = MEM_NH;
 
	return;
}
  
 

void
anf_ideal_2_delete WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
anf_ideal_2_delete.c
 
JS September 1991
Last modification: 02.10.91
 
Deletes the 2-element-presentation of an ideal but not the ideal itself.
 
*******************************************************************************/
{       
	block_declarations;
 
	if(!anf_ideal_is_2(id)) return;
 
	anf_elt_delete(ord, &anf_ideal_gen1(id));
	anf_elt_delete(ord, &anf_ideal_gen2(id));
        
	integer_delref(anf_ideal_gen_g(id));
	anf_ideal_gen_g(id) = 0;
 
	return;
}
   
 
 

void
anf_ideal_z_delete WITH_2_ARGS(
	order,		ord,
	anf_ideal,	id
)
/*******************************************************************************
 
anf_ideal_z_delete.c
 
JS September 1991
Last modification: 02.10.91
 
Deletes the Z-Basis-presentation of an ideal but not the ideal itself.
 
*******************************************************************************/
{       
	block_declarations;
 
        order		ordcoef;
 
	if(!anf_ideal_is_z(id)) return;
 
        ordcoef = order_coef_order(ord);
 
	mat_delref(ordcoef, &anf_ideal_tran(id));
	anf_ideal_tran(id) = MEM_NH;
 
	integer_delref(anf_ideal_tran_den(id));
 
	anf_ideal_tran_hnf(id) = 0;
 
	return;
} 
 
 

