/******************************************************************************
  anf_elt_logs_mat.c
******************************************************************************/

#include "kant.h"
#include "mat.h"
#include "vector.h"
#include "real.e"
#include "anf.h"

void
anf_elt_logs_mat WITH_4_ARGS(
	order,		ord,
	anf_elt,	alpha,
	matrix,		mat,
	integer_small,	colno
)
/*******************************************************************************
 
Description:

    Computes the logarithms of the absolute values of the conjugate vector of 
    an algebraic number in the actual precision.
 
    alpha might be given as integer, via coefficients or via conjugates. 
    The logarithm vector is stored in column No. colno of the matrix sumbitted.
    The number of logarithms stored in mat depends on the row dimension of
    mat which might be r1+r2 or r1+r2-1.
    The matrix must be allocated before.
                                        
 
Calling sequence:
 
	anf_elt_logs_mat(ord, alpha, mat, colno)
 
      	order         	ord     = t_handle of order 
        anf_elt         alpha   = algebraic number
        matrix          mat     = matrix to put in the logarithms
        integer_small   colno   = column of matrix
  
      
History:
 
	92-03-24 JS    renaming into anf_elt_logs_mat, using anf_elt_abs
	92-02-25 JS    deletion of two
	91-10-01 JS    written
  
*******************************************************************************/
{
	block_declarations;
 
	integer_small	i, rows;
	t_handle		R;
        vector		abs_vec;
 
 
	order_must_be_over_z(ord);
 
        rows  = mat_row(mat);
	R     = order_reals(ord);
 
/*
   we need the absolute values
*/ 
        abs_vec = anf_elt_abs(ord, alpha);
 
                                
/*
   now the logarithms
*/
 
	for (i=1; i<=rows; ++i)
	    mat_elt(mat, i, colno) = real_log(R, vec_entry(abs_vec, i));
  
	vec_delete(R, &abs_vec);
 
	return;	
}
