#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "real.e"


t_logical
anf_elt_is_primitive WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
 
	The function tests whether an algebraic element is primitive
        by looking  whether all conjugates are different.
	We cannot guarantee for the exact precision of this function.

 
Calling sequence:
 
	if(anf_elt_is_primitiv(ord, alpha)) ...
 
      	order  	        ord      = t_handle of order 
      	anf_elt         alpha    = algebraic number in ord 
      
 
History:
 
	92-02-04 AJ    written
 
*******************************************************************************/
{
 	block_declarations;         

 	int		i,j;
        integer_small   erg, erg2, r1, r2;
   	t_handle          reals;
        t_real          loceps, a,b, ac, bc, zero;
	anf_elt		beta;
                                    

/*** Initialisation  **********************************************************/

        r1= order_r1(ord);
        r2= order_r2(ord);

        reals = order_reals(ord);     
        loceps= real_make(reals, 10, -real_dec_prec(reals)+2 );  
        zero= conv_int_to_real(reals,0);

     	if (anf_elt_is_con(alpha))
		beta = anf_elt_incref(alpha);
	else
		beta = anf_elt_con(ord, alpha);

/*** Comparisation of the real conjugates  ************************************/

	for (i= 1;i<= r1; i++)  
	 {       
          a= real_incref(anf_con(beta, i));
	  for (j= i+1;j<= r1; j++)         
	   {
            b= real_incref(anf_con(beta, j)); 		    
            erg= real_equality_eps(reals, a, b, loceps); 

  	    if (anf_print_level >=5 )
     	     {
              printf("\nanf_elt_is_primitive:\n"); 		   
              printf("Real (%d,%d):\n",i,j); 		   
              real_write(reals, a, 20); printf("\n");
              real_write(reals, b, 20); printf("\n");
	      printf("Result:  %d\n", erg); 
	     }

            real_delete(&b);     

            if (erg)  
              {
                real_delete(&a);
		real_delete(&loceps);
		real_delete(&zero);
	        anf_elt_delete(ord, &beta);

		return FALSE;   
	      }           

       	   } /* end for: j */                    

          real_delete(&a);

	 } /* end for: i */                    

/*** Comparisation of the complex conjugates  *********************************/

	for (i= r1+1;i<= r1+r2; i++)         
	 {
          a=  real_incref(anf_con(beta, i)); 
          ac= real_abs(reals, anf_con(beta, i+r2));

          if (erg= real_equality_eps(reals, ac, zero, loceps))
	   {
           /* if the imaginary part is equal 0  */
  	    if (anf_print_level >=5 )
	     {
              printf("\nanf_elt_is_primitive:\n"); 		   
              printf("Complex ac (%d):\n",i); 		 
              real_write(reals, ac, 20); printf("\n");
              printf("Result:  %d\n", erg);
	     }                
            real_delete(&a);
            real_delete(&ac);
 	    real_delete(&loceps);
 	    real_delete(&zero);
	    anf_elt_delete(ord, &beta);

	    return FALSE;   
	   }

	  for (j= i+1;j<= r1+r2; j++)         
	   {  
            b= real_incref(anf_con(beta, j)); 		    
            erg= real_equality_eps(reals, a, b, loceps); 

  	    if (anf_print_level >=5 )
	     {
              printf("\nanf_elt_is_primitive:\n"); 		   
              printf("Complex (%d,%d):\n",i,j); 		 
              real_write(reals, a, 20); printf("\n");
              real_write(reals, b, 20); printf("\n");
              printf("Result:  %d\n", erg);
	     }
                   
             real_delete(&b);     

             if (erg)
              /* if the real parts are equal we test the absolute values
	         of imaginary parts */
	      {
               bc= real_abs(reals, anf_con(beta, j+r2)); 		    
               erg2= real_equality_eps(reals, ac, bc, loceps);

  	       if (anf_print_level >=5 )
	        {
                 printf("\nanf_elt_is_primitive:\n"); 		   
                 printf("Con. complex (%d,%d):\n",i,j); 		   
                 real_write(reals, ac, 20); printf("\n");
                 real_write(reals, bc, 20); printf("\n");
		 printf("Result:  %d\n", erg); 		   
	        }

               real_delete(&bc);     

               if (erg2)  
		 /* real parts and absolute values of imaginary parts equal:
		    not primitiv!  */ 
                 {
                  real_delete(&a);
                  real_delete(&ac);
	 	  real_delete(&loceps);
	 	  real_delete(&zero);
	          anf_elt_delete(ord, &beta);
		  return FALSE;   
	         }
	      } /* endif: erg */

       	   } /* end for: j */

          real_delete(&a);
          real_delete(&ac);

         } /* end for: i */

/*** End: the element is primitiv  *******************************************/

	real_delete(&loceps);
	real_delete(&zero);
	anf_elt_delete(ord, &beta);

	return TRUE;

} 

