;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald open-mapping)

(include-files
 (files (imps theories/metric-spaces/contraction)))


;;;(def-theorem iota-expression-in-set
;;;  "forall(p:[ind_1,prop], s:sets[ind_1], #(iota(i:ind_1,p(i))) implies ((iota(i:ind_1,p(i)) in s) iff forall(i:ind_1,p(i) implies (i in s))))"
;;;  (theory  pure-generic-theory-1)
;;;  (usages transportable-macete)
;;;  (proof 
;;;   (direct-and-antecedent-inference-strategy
;;;    (cut-with-single-formula "iota(i:ind_1,p(i))=i")
;;;    (backchain-backwards "with(i:ind_1,p:[ind_1,prop],iota(i:ind_1,p(i))=i);")
;;;    (eliminate-defined-iota-expression 0 w)
;;;    (backchain "with(w:ind_1,p:[ind_1,prop],forall(w_1:ind_1,p(w_1) implies w=w_1));")
;;;    (eliminate-defined-iota-expression 0 w)
;;;    (backchain "with(s:sets[ind_1],p:[ind_1,prop],forall(i:ind_1,p(i) implies i in s));"))))

;;;(def-compound-macete iota-expression-in-set-macete
;;;  (sequential
;;;   (sound
;;;    tr%abstraction-for-iota-body
;;;    beta-reduce
;;;    beta-reduce)
;;;   tr%iota-expression-in-set
;;;   beta-reduce))

(def-language AUGMENTED-MS-LANGUAGE
  (embedded-languages metric-spaces-language)
  (constants 
   (a pp)
   (r rr)))
      
(def-theory AUGMENTED-METRIC-SPACES
  (component-theories metric-spaces)
  (language augmented-ms-language)
  (axioms
   (positivity-of-r "0<=r")))

(set (current-theory) (name->theory 'augmented-metric-spaces))

(def-theorem ()
  "forsome(x_$0:pp,dist(x_$0,a)<=r)" 
  (theory augmented-metric-spaces)
  (proof "$METRIC_SPACES/proofs/triv-aug-dist.t"))

(def-theorem ()
  "forall(x,y,z:pp, 
    dist(x,a)<=r and dist(y,a)<=r and dist(z,a)<=r 
     implies
    dist(x,z)<=dist(x,y)+dist(y,z))"
  (proof "$METRIC_SPACES/proofs/triang-ineq-aug.t")
  (theory augmented-metric-spaces))

(def-theorem ()
 "forall(x,y:pp, 
    dist(x,a)<=r and dist(y,a)<=r 
     implies
    dist(x,y)=dist(y,x))"
 (theory augmented-metric-spaces)
 (proof "$METRIC_SPACES/proofs/symmetry-aug-dist.t"))

(def-theorem () 
  "forall(x,y:pp, 
     dist(x,a)<=r and dist(y,a)<=r 
      implies
     x=y iff dist(x,y)=0)"
  (proof "$METRIC_SPACES/proofs/point-sep-aug.t")
  (theory augmented-metric-spaces))

(def-theory-ensemble-instances
  metric-spaces 
  (target-theories augmented-metric-spaces)
  (multiples 1)
  (theory-interpretation-check using-simplification)
  (sorts (pp (pred "lambda(x:pp,dist(x,a)<=r)")))
  (constants (dist "lambda(x,y:pp,if(dist(x,a)<=r and dist(y,a)<=r, dist(x,y),?rr))"))
  (special-renamings 
   (ball res%ball)
   (open%ball res%open%ball)
   (lipschitz%bound res%lipschitz%bound)
   (lipschitz%bound%on res%lipschitz%bound%on)
   (complete res%complete)
   (cauchy res%cauchy)
   (lim res%lim)))

(def-theorem limit-definedness-extends
  "forall(s:[zz,pp],
     forall(x:zz,#(s(x)) implies s(x) in ball(a,r)) 
      implies 
     (#(res%lim(s)) iff #(lim(s))))"
  (theory augmented-metric-spaces)
  (proof "$METRIC_SPACES/proofs/res%lim-extends.t"))


(def-theorem limit-extends
  "forall(s:[zz,pp],
     #(lim(s)) and forall(x:zz,#(s(x)) implies s(x) in ball(a,r)) 
      implies 
     lim(s)=res%lim(s))"
  (theory augmented-metric-spaces)
  (proof "$METRIC_SPACES/proofs/lim%res-extends-1.t"))

(def-theorem cauchy-extends
  "forall(s:[zz,pp],
     res%cauchy(s) 
      iff
     (cauchy(s) and forall(x:zz,#(s(x)) implies s(x) in ball(a,r))))"
  (theory augmented-metric-spaces)
  (proof "$METRIC_SPACES/proofs/res%cauchy-extends.t"))


(def-theorem completeness-extends
  "complete implies res%complete"
  (theory augmented-metric-spaces)
  (proof "$METRIC_SPACES/proofs/res%complete-extends.t"))

(def-theorem invariance-of-ball
  "forall(f:[pp,pp],c:rr,x:pp, 
     lipschitz%bound%on(f,c,ball(a,r)) and dist(a,f(a))<r*(1-c) and x in ball(a,r) 
      implies
     f(x) in ball(a,r))"
  (theory augmented-metric-spaces)


  ;; Unfold-defined-constants (C-c U).
  ;; simplify-insistently.
  ;; Direct-and-antecedent-inference-strategy.
  ;; Instantiate-universal-antecedent with a, x.
  ;; For one subgoal, simplify-antecedent.
  ;; Simplify-insistently
  ;; cut with dist(a,x)*c<=r*c, simplify cut obligation.
  ;; Use macete triangle-inequality-alternate-form, and instantiate existential with
  ;; f(a).
  ;; simplify
 
  (proof "$METRIC_SPACES/proofs/invariance-of-ball.t"))


(def-theorem lipschitz%bound%on-extends
  "forall(f:[pp,pp],c:rr, 
     lipschitz%bound%on(f,c,ball(a,r)) and dist(a,f(a))<r*(1-c) 
      implies
     res%lipschitz%bound(restrict{f,ball(a,r)},c))"
  (theory augmented-metric-spaces)
  (proof "$METRIC_SPACES/proofs/lipschitz%bound%on-extends.t"))


(def-theorem restricted-fixed-point-theorem
  "forall(f:[pp,pp],c:rr, 
     complete and lipschitz%bound%on(f,c,ball(a,r)) and c<1 and dist(a,f(a))<r*(1-c) 
      implies
     forsome(x:pp, x in ball(a,r) and f(x)=x))"
  (home-theory augmented-metric-spaces)
  (theory metric-spaces)
  (usages transportable-macete)

  ;; Direct-and-antecedent-inference-strategy.
  ;; instantiate-transported-theorem, with:
  ;;   -- contractive-mapping-fixed-point-theorem
  ;;   -- metric-spaces-to-augmented-metric-spaces
  ;;   -- restrict(f,ball(a,r)), c
  ;; contrapose negated assumption, simplify-insistently and use invariance-of-ball
  ;; by replacing the assertion (with force-substitution) with f(x_0) in ball(a,r).
  ;; Handle force-substitution obligation by ball-membership-condition and simplify.
  ;; For other subgoal, also apply ball-membership-condition, auto-instantiate-existential
  ;; and simplify.
  ;; Some trivial cases handled by contraposition and macete-application or simplification. 
  ;; Finally, instantiate-existential with x.
  ;; Incorporate-antecedent which asserts something has a fixed point.
  ;; simplify insistently.

  (proof "$METRIC_SPACES/proofs/fixed-point-extends.t"))

