;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(define (DISPLAY-OBJECT-IN-TEX-FORMAT object port) ;object should be an imps object
  (cond	((expression? object)
	 (let ((tree (if (use-old-apply-operator-form?)
			 (expression->sexp object)
			 (drop-apply-operators (expression->sexp object)))))
	   (display-sexpression-in-tex-format tree port)))
	((sequent-node? object)
	 (bind (((dont-list-free-variables?) '#t))
	   (xtv-format port " \\subsection* \{Sequent ~a. \}"
		       (sequent-node-number object))
	   (display-sequent-free-variables object port)
	   (let ((assums (sequent-node-assumptions object)))
	     (if assums
		 (block (xtv-format port " \\subsection* \{Assume:\}")
			(display-expression-list-in-tex-format assums port)
			(xtv-format port "\\subsection* \{Then:\}"))))
	   (display-object-in-tex-format (sequent-node-assertion object) port)))
	((deduction-graph? object)
	 ((deduction-graph-tex-formatter) object port))
	((pair? object)
	 (walk
	  (lambda (o)
	    (display-object-in-tex-format o port))
	  object))
	((null? object)
	 (xtv-format port " \{ \\tt () \}"))
	((macete? object)
	 (display-macete-in-tex-format object port))
	((bnf? object)
	 (display-bnf-in-tex-format object port))
	((theory? object)
	 (display-theory-in-tex-format object port))
	((sorting? object)
	 (display-sort-in-tex-format object port))
	((or (symbol? object)
	     (string? object))
	 (xtv-format
	  port "~A"
	  (backslash-special-chars object)))
	(else (xtv-format port "Sorry, I do not know how to represent this object."))))
