;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald PRINT)


(define-structure-type SEXPRESSION-LABEL
  presentation-format
  presentation-method
  binding-power)

(define
  (MAKE-PRESENTATION-FORMAT formatter sexpression-label external-format presentation-method binding)
  (let ((token-parameters (make-sexpression-label)))
    (set (sexpression-label-presentation-format token-parameters) external-format)
    (set (sexpression-label-presentation-method token-parameters) presentation-method)
    (set (sexpression-label-binding-power token-parameters) binding)
    (set (table-entry (formatter-operator-table formatter) sexpression-label)
	 token-parameters)))
    
(define (PRESENTATION-FORMAT formatter token)
 (let ((occurs (table-entry (formatter-operator-table formatter) token)))
   (cond (occurs (sexpression-label-presentation-format occurs))
	 (else token))))

(define (PRESENTATION-METHOD formatter token)
 (let ((occurs (table-entry (formatter-operator-table formatter) token)))
   (cond (occurs (sexpression-label-presentation-method occurs))
	 (else (default-prefix-presentation-method formatter)))))

(define (PRESENTATION-BINDING-POWER formatter token)
 (let ((occurs (table-entry (formatter-operator-table formatter) token)))
   (cond (occurs (sexpression-label-binding-power occurs))
	 (else 200))))
;;;
;;;presentation-format of a token may be a  symbol or a string. Tokens
;;;which come directly from the imps list printer are atoms, while some
;;;tokens -- for example conjunctions or tex control tokens (see
;;;tex-formmatter below) -- are strings.  I admit this is a hack which with
;;;a little effort could be corrected. Is it really worth it?

(define FULLY-PARENTHESIZE
  (make-simple-switch 'fully-parenthesize boolean? '#f))

(define (PARENTHESIZE-CONDITIONALLY condition s-exp)
  (if (or condition (fully-parenthesize))
      `(\( ,s-exp \) ) s-exp))

(define (PRESENT-NARY-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    `(,*pp-block* 0
	    ,(cond ((null? args) `(,(presentation-format formatter op) \( \)))
		   ((null? (cdr args)) `(,(presentation-format formatter op)
					 \( ,(present-tree formatter (car args) 0) \)))
		   (else
		    (parenthesize-conditionally (> bp weight)
						(map-alternate-insert
						 (presentation-format formatter op)
						 (lambda (z)
						   `(,(present-tree formatter z weight) (,*pp-break* 0)))
						 args)))))))

(define (PRESENT-LOGICAL-NARY-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    `(,*pp-block* 0
	    ,(cond ((null? args) `(,(presentation-format formatter op) \( \)))
		   ((null? (cdr args)) `(,(presentation-format formatter op)
					 \( ,(present-tree formatter (car args) 0) \)))
		   (else
		    (parenthesize-conditionally (>= bp weight)
						(map-alternate-insert
						 `((,*pp-break* 0) ,(presentation-format formatter op) (,*pp-break* 0))
						 (lambda (z)
						   `(,(present-tree formatter z weight) ))
						 args)))))))

(define (PREFIX-OPERATOR-DELIMITERS op)
  (if (and (symbol->quasi-constructor op)
	   (treat-qcs-specially?))
      (return '\{ '\})
      (return '\( '\))))

(define (PRESENT-PREFIX-OPERATOR formatter op args bp)
  (receive (left-delimiter right-delimiter)
    (prefix-operator-delimiters op)
    (parenthesize-conditionally
     (> bp 200)
     `(,(presentation-format formatter op)
       ,left-delimiter
       (,*pp-block* 0
       
	,(map-alternate-insert `(\, (,*pp-break* 0)) (lambda (z) (present-tree formatter z 0)) args)
	,right-delimiter)))))

;;;(define (PRESENT-PREFIX-OPERATOR formatter op args bp)
;;;  (ignore bp)
;;;  `(,(presentation-format formatter op)
;;;    ,(parenthesize-conditionally t
;;;      (map-alternate-insert '\, (lambda (z) (present-tree formatter z 0)) args))))

(define (PRESENT-LOGLIKE-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally
     (>= bp weight)
     `(,(presentation-format formatter op) ,(present-tree formatter (car args) weight)))))

(define (PRESENT-NON-ASSOCIATIVE-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (>= bp weight)
     `(,*pp-block* 0
       ,(present-tree formatter (car args) weight)
       ;(,*pp-break* 0)
       ,(presentation-format formatter op)
       (,*pp-break* 0)
       ,(present-tree formatter (cadr args) weight)))))

(define (PRESENT-RELATIONAL-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (>= bp weight)
     `(,*pp-block* 0
       ,(present-tree formatter (car args) weight)
       (,*pp-break* 0)
       ,(presentation-format formatter op)
       ,(present-tree formatter (cadr args) weight)))))

(define (PRESENT-LOGICAL-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (>= bp weight)
     `(,*pp-block* 0
       ,(present-tree formatter (car args) weight)
       ;(,*pp-break* 0)
       (,*pp-break* 0)
	,(presentation-format formatter op)
       (,*pp-break* 0)
       ,(present-tree formatter (cadr args) weight)))))

(define (PRESENT-BINARY-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (> bp weight)
     `(,*pp-block* 0
       ,(present-tree formatter (car args) weight)
       (,*pp-break* 0)
       ,(presentation-format formatter op)
       ,(present-tree formatter (cadr args) (1+ weight))))))

(define (PRESENT-SUBTRACTION-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (>= bp weight)
     `(,*pp-block* 0
       ,(present-tree formatter (car args) weight) ;;used to be 0 for some unknow reason.
       ,(presentation-format formatter op)
       (,*pp-break* 0)
       ,(present-tree formatter (cadr args) weight)))))

(define (PRESENT-POSTFIX-OPERATOR formatter op args bp)
  (ignore bp)
  (parenthesize-conditionally
   '#f
   `(,(present-tree formatter (car args) (presentation-binding-power formatter op))
     ,(presentation-format formatter op))))

(define (PRESENT-SORT-DEPENDENT-PREFIX-OPERATOR formatter op args bp)
  (ignore bp)
  (let* ((args (reverse! args))
	 (sort (cadar args))
	 (rem-args (cdr args)))
    (receive (left-delimiter right-delimiter)
      (prefix-operator-delimiters op)
      `(,*pp-block* 0
	,(presentation-format formatter op)
	,left-delimiter
	,(alternate-insert
	 '\,
	 (append (map (lambda (z) (present-tree formatter z 0)) (reverse! rem-args))
		 (list (present-list sort))))
	,right-delimiter))))

;;;(define (PRESENT-SORT-DEPENDENT-PREFIX-OPERATOR formatter op args bp)
;;;  (ignore bp)
;;;  (let* ((args (reverse! args))
;;;	 (sort (cadar args))
;;;	 (rem-args (cdr args)))
;;;    `(,(presentation-format formatter op)
;;;      ,(parenthesize-conditionally
;;;	t
;;;	(alternate-insert
;;;	 '\,
;;;	 (append (map (lambda (z) (present-tree formatter z 0)) (reverse! rem-args))
;;;		 (list (present-list sort))))))))
;;;
;;;(define (PRESENT-LIST args)
;;;  (cond ((proper-list? args)
;;;	`(\[ ,@(map-alternate-insert '\, present-list args)
;;;		\]))
;;;	((atom? args) args)
;;;	(else args)));shouldn't get here.

(define arrow-for-function-specs
  (make-simple-switch 'arrow-for-function-specs boolean? '#f))

(define (PRESENT-LIST-WITH-SETS args)
  (cond ((proper-list? args)
	 (cond ((eq? (last args) 'unit%sort)
		(cons 'sets 
		      `(\[ ,@(map-alternate-insert '\, present-list-with-sets (all-but-last args))
			   \])))
	       ((arrow-for-function-specs)
		`(\[ ,@(map-alternate-insert '\, present-list-with-sets
					     (all-but-last args))
		     -> ,(PRESENT-LIST-WITH-SETS (last args)) \]))
	       (else
		`(\[ ,@(map-alternate-insert '\, present-list-with-sets args)
		  \]))))
	((atom? args) args)
	(else args)))
  
(define PRESENT-LIST PRESENT-LIST-WITH-SETS)

(define (PRESENT-UNDEFINED-OF-SORT formatter op args bp)
  (ignore bp)
  `(,*pp-block*
    0
    ,(presentation-format formatter op)
    ,(present-list (car args))))

(define (PRESENT-PREFIX-WITH-SORT-ARG formatter op args bp)
  (ignore bp)
  (receive (left-delimiter right-delimiter)
    (prefix-operator-delimiters op)
    `(,(presentation-format formatter op)
      ,left-delimiter ,(present-list (car args)) ,right-delimiter)))

(define (PRESENT-DEFINED-IN-SORT formatter op args bp)
  (ignore bp)
  `(,*pp-block*
    0
    ,(presentation-format formatter op)
    \( ,(present-tree formatter (car args) 0)  \, ,(present-list (cadr args)) \)))

(define (PRESENT-IN-SORT formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op)
    \( ,(present-tree formatter (car args) 0)  \, ,(present-list (cadr args)) \)))


;;;operators like sum and prod.


;;;(define (PRESENT-ITERATION-OPERATOR formatter op args bp)
;;;  (ignore bp)
;;;  (if (iteration-operator-same-binding-variables? args)
;;;      `(,(presentation-format formatter op)
;;;	\(
;;;	,(present-list (cadar args)) \,
;;;	,(present-tree formatter (caddar args) 0) \,
;;;	,(present-tree formatter (car (cddadr args)) 0)
;;;	\))
;;;      `(,(presentation-format formatter op)
;;;	\(
;;;	,(present-tree formatter (car args) 0)
;;;	\,
;;;	,(present-tree formatter (cadr args) 0)
;;;	\))))


(define (PRESENT-COND formatter op args bp)
  (ignore bp)
  `(,*pp-block*
    2
    ,(iterate loop ((args args)(accum '()))
    (let ((1st (present-tree formatter (car args) 0))
	  (2nd (present-tree formatter (cadr args) 0))
	  (3rd (caddr args)))
      (if (and (list? 3rd)
	       (eq? (car 3rd) op))
	  (loop (cdr 3rd) `( (,1st \, (,*pp-break* 1) ,2nd) ,@accum))
	  (let ((accum `( ,(present-tree formatter 3rd 0) 
			  (,1st \, (,*pp-break* 1) ,2nd) ,@accum)))
	    (if (= (length accum) 2)
		`(,(car (presentation-format formatter op))
		  \( ,@(map-alternate-insert  `(\, (,*pp-break* 1)) identity (reverse! accum)) \))
		`( ,(cadr (presentation-format formatter op))
		       \( ,(map-alternate-insert
				  `(\, (,*pp-break* 1)) identity
				  (reverse! accum)) \) ))))))))


;;;alternate nicer forms for printing binding operators:

(define (PRESENT-BINDING-OPERATOR formatter op args bp)
  (ignore bp)
  `(,*pp-block* 2
    ,(presentation-format formatter op)
    \( ,(present-specification-list (car args)) \, (,*pp-break* 0) ,(present-tree formatter (cadr args) 0)
    \)))

(define (PRESENT-BINDING-OPERATOR-1-LINE formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op)
    \( ,(present-specification-list (car args)) \, ,(present-tree formatter (cadr args) 0)
    \)))


(define (PRESENT-SPECIFICATION-LIST args)
  (map-alternate-insert '\, present-sort-specs args))


;;;(define (PRESENT-SORT-SPECS arg)
;;;  `(,(map-alternate-insert '\, identity (cdr arg)) \: ,(present-list (car arg))))

(define (PRESENT-SORT-SPECS arg)
  `(,(map-alternate-insert '\, identity (cdr arg)) \: ,(present-list-with-sets (car arg))))


(define-integrable (LIST-CONSTRUCTOR arg)
  (car arg))

(define-integrable (BINDING-LIST-VARIABLES arg) (caar (cadr arg)))

(define (BINDER-VARIABLES arg) ;;(lambda (((x y) zz)) body)
  (apply append (map cdr (cadr arg))))

(define-integrable (BINDER-BODY arg) (caddr arg))


(define (ITERATION-OPERATOR-SAME-BINDING-VARIABLES? args)
  (and (list? (car args))
       (list? (cadr args))
       (eq? (list-constructor (car args)) 'lambda)
       (eq? (list-constructor (cadr args)) 'lambda)
       (equal? (binding-list-variables (car args))
	       (binding-list-variables (cadr args)))))

(define (sort->string sort)
  (with-output-to-string
   port
   (let ((pt (output-port->imps-output-port-for-sorts port)))
     (write pt (sort->list sort)))))

(lset *form* (make-tree-formatter))
(set (default-prefix-presentation-method *form*) present-prefix-operator)
;;;arguments:formatter sexpression-label external-format presentation-method binding

(make-presentation-format *form* '+ '+ present-binary-infix-operator 100)
(make-presentation-format *form* '++ '++ present-binary-infix-operator 100)
(make-presentation-format *form* '- '- present-loglike-operator  111)
(make-presentation-format *form* 'sub '- present-subtraction-operator  110)
(make-presentation-format *form* '* '*  present-binary-infix-operator 120)
(make-presentation-format *form* '** '** present-non-associative-infix-operator 121)
(make-presentation-format *form* '\/ '\/ present-non-associative-infix-operator  121)
(make-presentation-format *form* '^ '^  present-non-associative-infix-operator 140)
(make-presentation-format *form* '^^ '^^  present-non-associative-infix-operator 140)
(make-presentation-format *form* 'factorial '! present-postfix-operator 160)
(make-presentation-format *form* 'is-defined '\# present-prefix-operator 160)
;;(make-presentation-format *form* 'diff '\' present-postfix-operator 160)
(make-presentation-format *form* '= '= present-relational-infix-operator 80)
(make-presentation-format *form* 'sub-function " sub_f " present-binary-infix-operator 80)
(make-presentation-format *form* 'sub-predicate " sub_p " present-binary-infix-operator 80)

(make-presentation-format *form* '== "==" present-relational-infix-operator 80)
(make-presentation-format *form* '> '>  present-binary-infix-operator 80)
(make-presentation-format *form* '>= '>=  present-binary-infix-operator 80)
(make-presentation-format *form* '< '<  present-relational-infix-operator 80)
(make-presentation-format *form* '<= '<=  present-relational-infix-operator 80)
(make-presentation-format *form* 'iff " iff "  present-logical-infix-operator 65)
(make-presentation-format *form* 'implies  " implies "  present-logical-infix-operator 59)
(make-presentation-format *form* 'and " and "  present-logical-nary-infix-operator 60)
(make-presentation-format *form* 'or " or "  present-logical-nary-infix-operator 50)
(make-presentation-format *form* 'forall 'forall  present-binding-operator 50)
(make-presentation-format *form* 'with 'with  present-binding-operator 50)
(make-presentation-format *form* 'lambda 'lambda  present-binding-operator 50)
(make-presentation-format *form* 'iota 'iota  present-binding-operator 50)
(make-presentation-format *form* 'forsome 'forsome  present-binding-operator 50)

;;;(make-presentation-format *form* 'with 'with  present-binding-operator 50)
;;;(make-presentation-format *form* 'lambda 'lambda  present-binding-operator-1-line 50)
;;;(make-presentation-format *form* 'iota 'iota  present-binding-operator 50)
;;;(make-presentation-format *form* 'forall 'forall  present-binding-operator 50)
;;;(make-presentation-format *form* 'forsome 'forsome  present-binding-operator 50)

(make-presentation-format *form* 'if-form '(if_form if_form) present-cond 80)
(make-presentation-format *form* 'if '(if if) present-cond 80)
;; formerly
;; (make-presentation-format *form* 'if-term '(if if) present-cond 80)
(make-presentation-format *form* 'if-pred '(if_pred if_pred) present-cond 80)
;;;
;;;(make-presentation-format *form* 'if-term '(if term_cond) present-prefix-operator 50)
;;;(make-presentation-format *form* 'if-form '(if_form if_form) present-prefix-operator 50)
;;;(make-presentation-format *form* 'if-pred '(if_pred if_pred) present-prefix-operator 50)

(make-presentation-format *form* 'undefined '?  present-undefined-of-sort 50)
(make-presentation-format *form* 'falselike 'falselike present-prefix-with-sort-arg 160)
(make-presentation-format *form* 'is-defined-in-sort '\# present-defined-in-sort 50)

(make-presentation-format *form* 'total? 'total_q present-sort-dependent-prefix-operator 160)
(make-presentation-format *form*  'vacuous? 'vacuous_q present-prefix-operator 160)
(make-presentation-format *form* 'reflexive? 'reflexive_q present-prefix-operator 160)
(make-presentation-format *form* 'transitive? 'transitive_q present-prefix-operator 160)
(make-presentation-format *form* 'antisymmetric? 'antisymmetric_q present-prefix-operator 160)
(make-presentation-format *form* 'comparable? 'comparable_q present-prefix-operator 160)
(make-presentation-format *form* 'well-founded? 'well_founded_q present-prefix-operator 160)
(make-presentation-format *form* 'partial-order? 'partial_order_q present-prefix-operator 160)
(make-presentation-format *form* 'linear-order? 'linear_order_q present-prefix-operator 160)
(make-presentation-format *form* 'upper-bound? 'upper_bound_q present-prefix-operator 160)
(make-presentation-format *form* 'chain? 'chain_q present-prefix-operator 160)
(make-presentation-format *form* 'cpo? 'cpo_q present-prefix-operator 160)
(make-presentation-format *form* 'monotone? 'monotone_q present-prefix-operator 160)
(make-presentation-format *form* 'continuous? 'continuous_q present-prefix-operator 160)
(make-presentation-format *form* 'nonvacuous? 'nonvacuous_q present-prefix-operator 160)

(define (QP-STRING exp)
  (sexp->output-string *form* (expression->sexp exp)))

;;;;presenter for tex-output:

;;;(define (OUTPUT-PORT->TEX-OUTPUT-PORT port)
;;;  (join
;;;  (object nil
;;;    ((write soi tree)
;;;     (iterate write-atoms-to-port
;;;	 ((x (present-tree *tex-form* tree 0)))
;;;       (cond ((null? x))
;;;	     ((string? x) (string->output soi x))
;;;	     ((symbol? x) (symbol->output soi x))
;;;	     ((atom? x) (atom->output soi x))
;;;	     (else (write-atoms-to-port (car x))
;;;		   (write-atoms-to-port (cdr x))))))
;;;  ((symbol->output soi x) (format port "~a" (tex-process-symbol x))))
;;;  port))

;;;(define (SEXP->TEX-STRING sexp)
;;;  (with-output-to-string
;;;   porto
;;;   (let ((pt (output-port->tex-output-port porto)))
;;;     (write pt sexp))))

;;;(define (imps-string-print-proc expr)
;;;  (sexp->output-string *form* (expression->sexp expr)))

(define (imps-string-print-proc sexp port)
  (write (output-port->imps-output-port port *form*) sexp)
  (write-char port #\;))

;;; Make imps-string-print-proc the standard imps printer.
(set (imps-printer) imps-string-print-proc)

;;; TeX printer.

(let ((table (make-hash-table pair? tree-hash equal? '#f)))

  (define (FIND-TEX-CORRESPONDENCE char-list)
    (let ((look-up (table-entry table char-list)))
      (cond (look-up)
	    ((<= 2 (length char-list))
	     (append '(#\{ #\\ #\r #\m #\space) char-list '(#\space #\})))
	    (else char-list))))
	     
	  

  (define (MAKE-TEX-CORRESPONDENCE symbol-or-str to-str)
    (let ((str (if (symbol? symbol-or-str)
		   (tex-process-symbol symbol-or-str)
		   symbol-or-str)))
      (set (table-entry table (string->list str)) (string->list to-str)))))


(define (TEX-PROCESS-SYMBOL x)
  (let ((explode (string->list (string-downcase! (symbol->string x)))))
    (list->string (process-characters-for-tex explode))))

;;;(define (PROCESS-CHARACTERS-FOR-TEX char-list)
;;;  (labels (((aux char-list)
;;;	    (cond ((null? char-list) "")
;;;		  ((char= (car char-list) #\$)
;;;		   (format nil
;;;			   "\\$~a" (aux (cdr char-list))))
;;;		  (else (string-append
;;;			 (char->string (char-downcase (car char-list)))
;;;			 (aux (cdr char-list)))))))
;;;    (cond ((and (= (length char-list) 2)
;;;		(alphabetic? (car char-list))
;;;		(char= (car char-list) (cadr char-list)))
;;;	   (format nil
;;;		   "\{ \\bf ~a \}"
;;;		   (char->string (char-upcase (car char-list)))))
;;;
;;;	  ((and (> (length char-list) 2)
;;;		(alphabetic? (car char-list))
;;;		(char= (car char-list) (cadr char-list))
;;;		(char= (caddr char-list) #\_))
;;;	   (format nil
;;;		   "\{ \\bf ~a \} ~a"
;;;		   (char->string (char-upcase (car char-list)))
;;;		   (aux (cddr char-list))))
;;;	  (else (aux char-list)))))



;;;(define (TWO-PERCENTS-HEAD char-list)
;;;  (and char-list (char= (car char-list) #\%)
;;;       (cdr char-list)
;;;       (char= (cadr char-list) #\%)))
;;;  

;;;(define (PROCESS-CHARACTERS-FOR-TEX char-list)
;;;  (if (and (two-percents-head char-list)
;;;	   (two-percents-head (reverse char-list)))
;;;      (process-characters-specially (cddr (reverse (cddr (reverse char-list)))))
;;;      (process-characters-normally char-list)))

;;;(define (PROCESS-CHARACTERS-SPECIALLY char-list)
;;;  `(#\{ #\\ #\b #\f #\space
;;;	,@(apply append (map (lambda (x) (if (char= #\% x) (list #\\ #\_) (list x)))
;;;			     char-list))
;;;	#\}))
;;;
;;;
;;;(define (FIND-TEX-CORRESPONDENCE-1 char-list)
;;;  (if (and (two-percents-head char-list)
;;;	   (two-percents-head (reverse char-list)))
;;;      (process-characters-specially (cddr (reverse (cddr (reverse char-list)))))
;;;      (find-tex-correspondence char-list)))
;;;

(define dont-subscript-underscores?
  (make-simple-switch 'dont-subscript-underscores? boolean? '#f))

(define (PROCESS-CHARACTERS-FOR-TEX char-list)
  (iterate loop ((x char-list) (current '()) (accum '()) (tail '()))
    (cond ((null? x) 
	   (append accum (append (find-tex-correspondence (reverse! current)) tail)))
	  ((and (char= (car x) #\_) (dont-subscript-underscores?))
	   (loop (cdr x) `(#\_ #\\ ,@current) accum tail))
	  ((and (cdr x) (char= (car x) #\_) )
	   (let ((current (find-tex-correspondence (reverse! current))))
	     (loop (cdr x) '()
		   (append accum `(,@current #\_ #\{))
		   (cons #\} tail))))
	  ((char= (car x) #\_)
	   (loop (cdr x) `(#\} #\{ ,#\_ ,@current) accum tail))
;;;	  ((char= (car x) #\^)
;;;	   (loop (cdr x) `(,@(tex-verbatim (car x)) ,@current) accum tail))
	  ((char= (car x) #\%)
	   (loop (cdr x) `(#\_ #\\ ,@current) accum tail))
	  ((char= (car x) #\$)
	   (loop (cdr x) `(#\$ #\\ ,@current) accum tail))
	  ;; remember, were putting it in backwards.
	  (else (loop (cdr x) (cons (car x) current) accum tail)))))

;;;(define (TEX-VERBATIM char) 
;;; `(#\2 ,char #\2  #\b #\r #\e #\v #\\ ))
	  
;;;
;;;(define (BRACKET-SUBSCRIPTS x)
;;;  (cond ((null? x) '())
;;;	((and (cdr x) (char= (car x) #\_) `(#\_ #\{ ,@(bracket-subscripts (cdr x)) #\})))
;;;	((char= (car x) #\_) `(#\_))
;;;	(else (cons (car x) (bracket-subscripts (cdr x))))))
;;;
;;;


(define MAXIMUM-NESTING-FOR-LOGICAL-EXPRESSIONS
  (make-simple-switch 'max-nesting integer? 3))

(define CURRENT-INDENTATION
  (make-simple-switch 'depth string? ""))

(define CURRENT-BULLET-SYMBOL
  (make-simple-switch 'symbol list?
		      '(" \\bullet " " \\bullet \\,"  " \\circ \\," " \\diamond \\, " " \\bowtie \\," " \\dagger \\,"  "\\sharp \\, " " \\cdot ")))

;;;who needs this?
;;;(set (composite-presentation-method *tex-form*)
;;;     (lambda (formatter op args binding-power)
;;;       (ignore binding-power)
;;;       (let ((arg-present
;;;	      `(,(map-alternate-insert '\, (lambda (z) (present-tree formatter z 0)) args))))
;;;       (cond ((or (eq? (car op) 'lambda)
;;;		  (and (eq? (car op) 'diff)
;;;		       (list? (cadr op))
;;;		       (eq? (caadr op) 'lambda)))
;;;	      `(,(present-tree formatter op 0) " \\quad " \( ,arg-present \) ))
;;;	     (else	     
;;;	      `(,(present-tree formatter op 0) \( ,arg-present \)))))))
;;;

(define (PRESENT-TEX-SUBTRACTION-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (>= bp weight)
     `(,(present-tree formatter (car args) 0)
       ,(presentation-format formatter op)
       ,(present-tree formatter (cadr args) weight)))))

(define (PREFIX-TEX-OPERATOR-DELIMITERS op)
  (if (and (symbol->quasi-constructor op)
	   (treat-qcs-specially?))
      (return " \\{ " " \\} ")
      (return '\( '\))))

(define (PRESENT-TEX-PREFIX-OPERATOR formatter op args bp)
  (ignore bp)
  (receive (left-delimiter right-delimiter)
    (prefix-tex-operator-delimiters op)
  `(,(presentation-format formatter op)
    ,left-delimiter
    ,(map-alternate-insert '\, (lambda (z) (present-tree formatter z 0)) args)
    ,right-delimiter)))

(define (PRESENT-TEX-SORT-DEPENDENT-PREFIX-OPERATOR formatter op args bp)
  (ignore bp)
  (let* ((args (reverse! args))
	 (sort (cadar args))
	 (rem-args (cdr args)))
    `(,(presentation-format formatter op)
      ,(parenthesize-conditionally
	t
	(alternate-insert
	 '\,
	 (append (map (lambda (z) (present-tree formatter z 0)) (reverse! rem-args))
		 (list (present-tex-sorting sort '#f))))))))

;;;(presentation-format formatter op) is a list (form1 form2) where form1
;;;is the format for top-level presentation, form2 that for presentation within
;;;certain operators.

;;;(define (PRESENT-TEX-LOGICAL-OPERATOR formatter op args bp)
;;;  (let ((weight (presentation-binding-power formatter op)))
;;;    (if (> (maximum-nesting-for-logical-expressions) 0)
;;;      (bind (((current-indentation) (string-append (current-indentation) "X"))
;;;	     ((current-bullet-symbol) (cdr (current-bullet-symbol)))
;;;	     ((maximum-nesting-for-logical-expressions)
;;;	      (subtract1 (maximum-nesting-for-logical-expressions))))
;;;	`(,(car (presentation-format formatter op))
;;;	  " \\newline "
;;;	  ,(map-alternate-insert
;;;	    " \\newline "
;;;	    (lambda (z) `(,(format nil " \\phantom\{~a\} " (current-indentation))
;;;			   ,(car (current-bullet-symbol))
;;;			   ,(present-tree formatter z weight))) args)))
;;;      (parenthesize-conditionally (> bp weight)
;;;				  (map-alternate-insert
;;;				   (cadr (presentation-format formatter op))
;;;				   (lambda (z) (present-tree formatter z weight))
;;;				   args)))))

(define (PRESENT-TEX-BINARY-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (> bp weight)
     `(,(present-tree formatter (car args) weight)
       ,(presentation-format formatter op)
       ,(present-tree formatter (cadr args) weight)))))

(define (PRESENT-TEX-LOGICAL-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (if (> (maximum-nesting-for-logical-expressions) 0)
      (bind (((current-indentation) (string-append (current-indentation) "X"))
	     ((current-bullet-symbol) (cdr (current-bullet-symbol)))
	     ((maximum-nesting-for-logical-expressions)
	      (subtract1 (maximum-nesting-for-logical-expressions))))
	`(,(car (presentation-format formatter op))
	  " \\newline "
	  ,(map-alternate-insert
	    " \\newline "
	    (lambda (z) `(,(format nil " \\phantom\{~a\} " (current-indentation))
			   ,(car (current-bullet-symbol))
			   ,(present-tree formatter z 0))) args)))
      ;; 0 used to be weight. Since nested expressions print on different
      ;; lines one can assume each expression is printed at the top level.
      (parenthesize-conditionally (> bp weight)
				  (map-alternate-insert
				   (cadr (presentation-format formatter op))
				   (lambda (z) (present-tree formatter z weight))
				   args)))))


;;;(define (PRESENT-TEX-CONDITIONAL-FORMULA formatter op args bp)
;;;
;;;  (if (> (maximum-nesting-for-logical-expressions) 0)
;;;      (let ((weight (presentation-binding-power formatter op)))
;;;	(bind (((current-indentation) (string-append (current-indentation) "X"))
;;;	       ((current-bullet-symbol) (cdr (current-bullet-symbol)))
;;;	       ((maximum-nesting-for-logical-expressions) 0))
;;;	  `( " \{ \\bf  conditionally \}  "
;;;	     " \\newline "
;;;	     ,(format nil " \\phantom\{~a\} " (current-indentation))
;;;	     ,(car (current-bullet-symbol))
;;;	     ,(present-tree formatter (cadr args) weight)
;;;	     " , "
;;;	     " \\quad\{ \\bf if \} \\quad "
;;;	     ,(present-tree formatter (car args) weight)
;;;	     " \\newline "
;;;	     ,(format nil " \\phantom\{~a\} " (current-indentation))
;;;	     ,(car (current-bullet-symbol))
;;;	     ,(present-tree formatter (caddr args) weight)
;;;	     " \\quad \{ \\bf  otherwise \} ")))
;;;	(present-tex-nostrict-if formatter op args bp)))

(define (PRESENT-TEX-CONDITIONAL-FORMULA-old formatter op args bp)
  (ignore bp)
  (let ((newlines? (> (maximum-nesting-for-logical-expressions) 0)))
  (bind (((current-indentation) (string-append (current-indentation) "X"))
	 ((current-bullet-symbol) (cdr (current-bullet-symbol)))
	 ((maximum-nesting-for-logical-expressions) 0))

	
    (receive (last args)
      (iterate loop ((args args) (accum '()))
	(let ((1st (present-tree formatter (car args) 0))
	      (2nd (present-tree formatter (cadr args) 0))
	      (3rd (caddr args)))
	  (if (and (list? 3rd)
		   (eq? (car 3rd) op))
	      (loop (cdr 3rd) `(( ,1st ,2nd ) ,@accum))
	      (return 
	       (present-tree formatter 3rd 0) 
	       (reverse `(( ,1st ,2nd ) ,@accum))))))
      (if newlines?
      `( " \\mbox{ conditionally }  "
	 " \\newline "
	 ,(format nil " \\phantom\{~a\} " (current-indentation))
	 ,(car (current-bullet-symbol))
	 ,(map-alternate-insert
	   (list 
	    " \\newline "
	    (format nil " \\phantom\{~a\} " (current-indentation))
	    (car (current-bullet-symbol)))
	   (lambda (x) (list " \\mbox{ if }" (car x) " \\mbox{ then }" (cadr x)))
	   args)
	 " \\newline "
	 ,(format nil " \\phantom\{~a\} " (current-indentation))
	 ,(car (current-bullet-symbol))
	 " \\mbox{ otherwise }"
	 ,last)
      `( ,(map-alternate-insert
	   '\,
	   (lambda (x) (list " \\mbox{ if }" (car x) " \\mbox{ then }" (cadr x)))
	   args)
	 " \\mbox{ otherwise }"
	 ,last))))))


(define (PRESENT-TEX-CONDITIONAL-FORMULA formatter op args bp)
  (ignore bp)
  (let ((newlines? (> (maximum-nesting-for-logical-expressions) 0)))
    (bind (((current-indentation) (string-append (current-indentation) "X"))
	   ((current-bullet-symbol) (cdr (current-bullet-symbol)))
	   ((maximum-nesting-for-logical-expressions) 0))

	
      (receive (last args)
	(iterate loop ((args args) (accum '()))
	  (let ((1st (present-tree formatter (car args) 0))
		(2nd (present-tree formatter (cadr args) 0))
		(3rd (caddr args)))
	    (if (and (list? 3rd)
		     (eq? (car 3rd) op))
		(loop (cdr 3rd) `(( ,1st ,2nd ) ,@accum))
		(return 
		 (present-tree formatter 3rd 0) 
		 (reverse `(( ,1st ,2nd ) ,@accum))))))
	(cond ((not newlines?)
	       `( ,(map-alternate-insert
		    '\,
		    (lambda (x)
		      (list " \\mbox{ if }" (car x)
			    " \\mbox{ then }" (cadr x)))
		    args)
		  " \\mbox{ otherwise }"
		  ,last))
	      ((= (length args) 1)
	       `(" \\mbox{ conditionally, if }  "
		 ,(caar args)
		 " \\newline "
		 ,(format nil " \\phantom\{~a\} " (current-indentation))
		 ,(car (current-bullet-symbol))
		 " \\mbox{ then }"
		 ,(cadar args)
		 " \\newline "
		 ,(format nil " \\phantom\{~a\} " (current-indentation))
		 ,(car (current-bullet-symbol))
		 " \\mbox{ otherwise }"
		 ,last))
	      (else 
	       `( " \\mbox{ conditionally }  "
		  " \\newline "
		  ,(format nil " \\phantom\{~a\} " (current-indentation))
		  ,(car (current-bullet-symbol))
		  ,(map-alternate-insert
		    (list 
		     " \\newline "
		     (format nil " \\phantom\{~a\} " (current-indentation))
		     (car (current-bullet-symbol)))
		    (lambda (x) (list " \\mbox{ if }" (car x) " \\mbox{ then }" (cadr x)))
		    args)
		  " \\newline "
		  ,(format nil " \\phantom\{~a\} " (current-indentation))
		  ,(car (current-bullet-symbol))
		  " \\mbox{ otherwise }"
		  ,last)))))))     
  

(define (PRESENT-TEX-NON-ASSOCIATIVE-INFIX-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op)))
    (parenthesize-conditionally (>= bp weight)
     `(,(present-tree formatter (car args) weight)
       ;(,*pp-break* 0)
       ,(presentation-format formatter op)
       ,(present-tree formatter (cadr args) weight)))))

(define (PRESENT-TEX-EXPONENTIATION formatter op args bp)
  (ignore bp)
  (let ((weight (presentation-binding-power formatter op)))
    `(\{ ,(present-tree formatter (car args) weight) \}
	 ,(presentation-format formatter op)
	 \{ ,(present-tree formatter (cadr args) 0) \})))

;;;(define (PRESENT-TEX-BINDING-OPERATOR formatter op args bp)
;;;  (ignore bp)
;;;  `(,(presentation-format formatter op)
;;;    ,(present-tex-parameter-list (car args))
;;;    ," \\quad "
;;;    ,(present-tree formatter (cadr args) 0)))

(define (PRESENT-TEX-QUANTIFICATION-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op))
	(top-level-form
	 (if (list? (presentation-format formatter op))
	     (car (presentation-format formatter op))
	     (presentation-format formatter op)))
	(nested-form (if (list? (presentation-format formatter op))
			 (cadr (presentation-format formatter op))
			 (presentation-format formatter op))))

  (if (> (maximum-nesting-for-logical-expressions) 0)
      `(,top-level-form
	,(present-tex-parameter-list (car args))
	," \\quad "
	,(present-tree formatter (cadr args) 0))
      (parenthesize-conditionally
		  (> bp weight)
		  `(,nested-form 
		    ,(present-tex-parameter-list (car args))
		    " \\quad "
		
		    ,(present-tree formatter (cadr args) 0))))))

(define (PRESENT-TEX-LAMBDA-ABSTRACTION formatter op args bp)
  (ignore bp)
  `(    " [ \\," 

    ,(present-tex-parameter-list (car args))
     " \\, " " \\mapsto " " \\, "

    ,(present-tree formatter (cadr args) 0)

    "\\, ] "))

(comment
 Used to be:
 (define (PRESENT-TEX-LAMBDA-ABSTRACTION formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op)
    " \\{ "
    ,(present-tex-parameter-list (car args))
     " \\, " " | " " \\, "

    ,(present-tree formatter (cadr args) 0)

    " \\} ")))


(define (PRESENT-TEX-WITH formatter op args bp)
  (ignore bp)
  (if (or (brief-parameter-specification?)
	  (dont-list-free-variables?))
      (present-tree formatter (cadr args) 0)
      `(,(presentation-format formatter op)
	,(present-tex-parameter-list (car args))
	," \\quad "
	,(present-tree formatter (cadr args) 0))))


(define (PRESENT-TEX-PARAMETER-LIST args)
  (map-alternate-insert '\,  present-tex-parameter-specification args))

(define brief-parameter-specification?
  (make-simple-switch 'parameter-brevity boolean? '#f))

(define dont-list-free-variables?
  (make-simple-switch 'conceal-free-variables boolean? '#f))


(define (PRESENT-TEX-PARAMETER-SPECIFICATION spec)
  (if (brief-parameter-specification?) (alternate-insert '\, (cdr spec))
      `(,@(alternate-insert '\, (cdr spec)) ," : "  ,(present-tex-sorting (car spec) '#t))))


;;;(define (PRESENT-TEX-SORTING sorting top-level)
;;;  (cond ((atom? sorting) sorting)
;;;	(else (let ((rev (reverse (map (lambda (x) (present-tex-sorting x '#f)) sorting)))
;;;		    (cross " \\times "  )
;;;		    (into " \\rightarrow "  ))
;;;		(let ((presentation
;;;		       (reverse `(,(car rev) ,into ,@(alternate-insert cross (cdr rev))))))
;;;		  (if top-level presentation
;;;		      `( \[ ,presentation \])))))))

(define (PRESENT-TEX-SORTING sorting top-level)
  (cond ((atom? sorting) sorting)
	(else (let ((rev (reverse (map (lambda (x) (present-tex-sorting x '#f)) sorting)))
		    (cross " \\times "  )
		    (into " \\rightharpoonup "  ))
		(if (eq? (car rev) 'unit%sort)
		    `( sets \[ ,@(alternate-insert cross (reverse (cdr rev))) \] )
		    (let ((presentation
			   (reverse `(,(car rev) ,into ,@(alternate-insert cross (cdr rev))))))
		      (if top-level presentation
			  `( \[ ,presentation \]))))))))


(define (PRESENT-TEX-DIFFERENTIATION formatter op args bp)
  (ignore bp)
  (cond ((and (list? (car args)) (eq? (caar args) 'lambda))
	 (present-tex-leibniz-notation formatter op args))
	(else (present-tex-newton-notation formatter op args))))

(define (PRESENT-TEX-LEIBNIZ-NOTATION formatter op args)
  (let* ((weight (presentation-binding-power formatter op))
	 (var (present-tree formatter (caaar (cadar args)) 0))
	 (body (present-tree formatter (caddr (car args)) weight))
	 (degree (if (= 1 (cadr args)) '()
		     (list (present-tree formatter (cadr args) 0)))))
    `(\{ d ^ \{ ,degree \} ,body ," \\over "    d ,var ^ \{ ,degree \} \})))
    

(define (PRESENT-TEX-NEWTON-NOTATION formatter op args)
  (let ((weight (presentation-binding-power formatter op))
	(degree (cond ((= (cadr args) 1) " \\prime "  )
		      ((= (cadr args) 2) (list " \\prime "  
					       " \\prime "  ))
		      (else (present-tree formatter (cadr args) 0)))))
    `(\{ ,(present-tree formatter (car args) weight) \}
	  ^
	 \{ ,degree \})))

(define (PRESENT-TEX-UNDEFINED-OF-SORT formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op) \_ \{ ,(present-tex-sorting (car args) '#f) \}))

(define (PRESENT-SUBSCRIPTED-SORT-ARG formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op) \_ \{ ,(present-tex-sorting (car args) '#f) \}))

(define (PRESENT-TEX-DEFINED-IN-SORT formatter op args bp)
  (ignore bp)
  `(
    ,(present-tree formatter (car args) 0)
    ,(presentation-format formatter op)
    ,(present-tex-sorting (cadr args)'#f) ))

(define (PRESENT-TEX-IN-SORT formatter op args bp)
  (ignore bp)
  `( ,(presentation-format formatter op) 
     \( ,(present-tree formatter (car args) 0) \, ,(present-list (cadr args)) \)))

(define (PRESENT-TEX-NONSTRICT-IF formatter op args bp)
  (ignore op bp)
  (bind (((maximum-nesting-for-logical-expressions) 0))
    `(
      
      ;; ," \\left "
      
      ,"\\{"
      ,(present-tree formatter (cadr args) 0) 
      "\\mbox \{ if \}"
      ,(present-tree formatter (car args) 0)
      "\\mbox\{,  otherwise   \}"
      ,(present-tree formatter (caddr args) 0)
      
      ;; ," \\right "
      
      ,"\\}")))

(define (PRESENT-TEX-DELIMITED-EXPRESSION formatter op args bp)
  (ignore bp)
  `(,(car (presentation-format formatter op))
    
    ,(alternate-insert '\, (map (lambda (x) (present-tree formatter x 0)) args))

    ,(cadr (presentation-format formatter op))))


(define (PRESENT-TEX-DELIMITED-EXPRESSION-WITH-DOTS formatter op args bp)
  (ignore bp)
  `(,(car (presentation-format formatter op))
    
    ,(alternate-insert '\. (map (lambda (x) (present-tree formatter x 0)) args))

    ,(cadr (presentation-format formatter op))))

(define (PRESENT-TEX-DELIMITED-EXPRESSION-WITH-two-colons formatter op args bp)
  (ignore bp)
  `(,(car (presentation-format formatter op))
    
    ,(alternate-insert '\:: (map (lambda (x) (present-tree formatter x 0)) args))

    ,(cadr (presentation-format formatter op))))


(define (PRESENT-TEX-BRACED-ARGUMENTS formatter op args bp)
  (ignore bp)
  `(,(presentation-format formatter op)
    " { " 
    ,(alternate-insert '\, (map (lambda (x) (present-tree formatter x 0)) args))
    " } "))

(define (PRESENT-TEX-CHOOSE formatter op args bp)
  (ignore bp)
  `(" { "
    " { "
    ,(present-tree formatter (car args) 0)
    " } "
    ,(presentation-format formatter op)
    " { "
    ,(present-tree formatter (cadr args) 0)
    " } "
    " } "))

;;;(define (PRESENT-TEX-ITERATION-OPERATOR formatter op args bp)
;;;  (bind (((maximum-nesting-for-logical-expressions) 0))
;;;    (let ((weight (presentation-binding-power formatter op)))
;;;      (parenthesize-conditionally
;;;       (>= bp weight)
;;;       (cond((iteration-operator-same-binding-variables? args)
;;;	     (cond ((full-interval-range-of-summation? args)
;;;		    `(,(presentation-format formatter op)
;;;		      "_{ "
;;;		      ,(present-tree formatter (caaar (cadr (car args))) 0)
;;;		      "="
;;;		      ,(present-tree formatter (cadr (cadr (caddr (car args)))) 0)
;;;		      "}"
;;;		      "^{"
;;;		      ,(present-tree formatter (caddr (caddr (caddr (car args)))) 0)
;;;		      "}"
;;;		      ,(present-tree formatter (car (cddadr args)) 0)))
;;;		   ((partial-interval-range-of-summation? args)
;;;		    `(,(presentation-format formatter op)
;;;		      "_{ "
;;;		      ,(present-tree formatter (cadr (cadr (caddr (car args)))) 0) ;first limit
;;;		      ,(presentation-format formatter (car (cadr (caddr (car args))))) ; first ineq.
;;;		      ,(present-tree formatter (caaar (cadr (car args))) 0) ;index
;;;		      ,(presentation-format formatter (car (caddr (caddr (car args))))) ; 2nd ineq.
;;;		      ,(present-tree formatter (caddr (caddr (caddr (car args)))) 0) ;2nd limit
;;;		      "}"
;;;		      ,(present-tree formatter (car (cddadr args)) 0)))
;;;		   (else
;;;		    `(,(presentation-format formatter op)
;;;		      " \\{ "
;;;		      ,(present-tex-parameter-list (cadar args)) \,
;;;		      ,(present-tree formatter (caddar args) 0) 
;;;		      " \\, " " | " " \\, "
;;;		      ,(present-tree formatter (car (cddadr args)) 0)
;;;		      " \\} "))))
;;;	    ((partial-interval-range-of-summation? args)
;;;	     `(,(presentation-format formatter op)
;;;	       "_{ "
;;;;;;	    " \\lambda "
;;;;;;	    ,(present-tree formatter (caaar (cadr (car args))) 0) ;index
;;;	       " \\, "
;;;	       ,(present-tree formatter (cadr (cadr (caddr (car args)))) 0) ;first limit
;;;	       ,(presentation-format formatter (car (cadr (caddr (car args))))) ; first ineq.
;;;	       ,(present-tree formatter (caaar (cadr (car args))) 0) ;index
;;;	       ,(presentation-format formatter (car (caddr (caddr (car args))))) ; 2nd ineq.
;;;	       ,(present-tree formatter (caddr (caddr (caddr (car args)))) 0) ;2nd limit
;;;	       "}"
;;;	       ,(present-tree formatter (cadr args) 0)))
;;;	    (else `(,(presentation-format formatter op)
;;;		    \(
;;;		    ,(present-tree formatter (car args) 0)
;;;		    \,
;;;		    ,(present-tree formatter (cadr args) 0) \))))))))
;;;
;;;
;;;(define (FULL-INTERVAL-RANGE-OF-SUMMATION? args)
;;;  (if (and (list? args)
;;;	   (list? (car args))
;;;	   (eq? (caar args) 'lambda)
;;;	   (>= (length (car args)) 3))
;;;      (let ((range (caddr (car args))))
;;;	(and
;;;	 (list? range)
;;;	 (eq? (car range) 'and)
;;;	 (eq? (car (cadr range)) '<=)
;;;	 (eq? (car (caddr range)) '<=)
;;;	 (= (length range) 3)
;;;	 (eq? (caddr (cadr range)) (caaar (cadr (car args))))
;;;	 (eq? (cadr (caddr range)) (caaar (cadr (car args))))))
;;;      '()))
;;;
;;;(define (PARTIAL-INTERVAL-RANGE-OF-SUMMATION? args) ;a R_1 j and j R_2 b
;;;  (if (and (list? args)
;;;	   (list? (car args))
;;;	   (eq? (caar args) 'lambda)
;;;	   (>= (length (car args)) 3))
;;;      (let ((range (caddr (car args))))
;;;	(and 
;;;	 (list? range)
;;;	 (eq? (car range) 'and)
;;;	 (memq? (car (cadr range)) '(<= <))
;;;	 (memq? (car (caddr range)) '(<= <))
;;;	 (= (length range) 3)
;;;	 (eq? (caddr (cadr range)) (caaar (cadr (car args))))
;;;	 (eq? (cadr (caddr range)) (caaar (cadr (car args))))))
;;;      '()))
;;;	      


(define (PRESENT-TEX-INTERVAL-ITERATION-OPERATOR formatter op args bp)
  (ignore bp)
  ;;op(a,b,f)
  (let ((low (present-tree formatter (car args) 0))
	(up (present-tree formatter (cadr args) 0))
	(fn (caddr args)))
    (if (and (list? fn) (eq? (car fn) 'lambda) (= (length (binder-variables fn)) 1))
	`(,(presentation-format formatter op)
	  "_{ "
	  ,(car (binder-variables fn))
	  " = "
	  ,low
	  " } "
	  "^{ "
	  ,up
	  " } "
	  ,(present-tree formatter (binder-body fn) 0))
	`(,(presentation-format formatter op)
	  "_{ "
	  ,low
	  " } "
	  "^{ "
	  ,up
	  " } "
	  ,(present-tree formatter fn 0)))))


(define (PRESENT-TEX-LIMIT-OPERATOR formatter op args bp)
  (ignore bp)
  ;;op(f)
  (let ((fn (car args)))
    (if (and (list? fn) (eq? (car fn) 'lambda) (= (length (binder-variables fn)) 1))
	`(,(presentation-format formatter op)
	  "_{ "
	  ,(car (binder-variables fn))
	  " \\rightarrow \\infty } "
	  ,(present-tree formatter (binder-body fn) 0))
	`(,(presentation-format formatter op)
	  ,(present-tree formatter fn 0)))))

(define (PRESENT-TEX-SYMBOL formatter op args bp)
  (ignore args bp)
  `(,(presentation-format formatter op)))

(lset *tex-form* (make-tree-formatter))
(set (default-prefix-presentation-method *tex-form*) present-tex-prefix-operator)
(set (composite-presentation-method *tex-form*) 
     (lambda (formatter op args binding-power)
	   (parenthesize-conditionally
	    (> binding-power 200)
	    `(,(present-tree formatter op 200)
	      \( ,(alternate-insert '\, (map (lambda (z) (present-tree formatter z 0)) args)) \) ))))

(make-presentation-format *tex-form* '+ '+ present-tex-binary-infix-operator 100)
(make-presentation-format *tex-form* '++ '+ present-tex-binary-infix-operator 100)
(make-presentation-format *tex-form* '- '- present-loglike-operator  110)
(make-presentation-format *tex-form* 'sub '- present-tex-subtraction-operator  110)
(make-presentation-format *tex-form* '*  " \\cdot " present-tex-binary-infix-operator 120)
(make-presentation-format *tex-form* '**  " \\cdot " present-tex-binary-infix-operator 120)
(make-presentation-format *tex-form* '\/ '\/ present-tex-non-associative-infix-operator  121)
(make-presentation-format *tex-form* '^ '^  present-tex-exponentiation 140)
;;;see below
(make-presentation-format *tex-form* '^^ '^  present-tex-exponentiation 140)
(make-presentation-format *tex-form* 'factorial '! present-postfix-operator 160)
(make-presentation-format *tex-form* 'is-defined " \\downarrow "   
			  present-postfix-operator 160)
;;;
(make-presentation-format *tex-form* '= '= present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* 'sub-function  " \\sqsubseteq " present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* 'included " \\subseteq "  present-tex-binary-infix-operator 80)

(make-presentation-format *tex-form* 'total? 'total present-tex-sort-dependent-prefix-operator 160)

(make-presentation-format *tex-form* '== " \\simeq " present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* '> '>  present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* '>= " \\geq "     present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* '< '<  present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* '<= " \\leq "     present-tex-binary-infix-operator 80)
(make-presentation-format *tex-form* 'abs (list " | " " | ") present-tex-delimited-expression 80)
(make-presentation-format *tex-form* 'sqrt " \\sqrt " present-tex-braced-arguments 160)

(make-presentation-format *tex-form* 'iff  (list "\\iff " "\\iff ")     present-tex-logical-operator 65)
(make-presentation-format *tex-form* 'implies (list "\{ \\rm implication \}"
						    " \\supset ")
			  present-tex-logical-operator 64)


(make-presentation-format *tex-form* 'not " \\neg " present-tex-prefix-operator 200)

(make-presentation-format *tex-form* 'and (list "\{ \\rm conjunction \} "
						" \\wedge ")
			  present-tex-logical-operator 60)

(make-presentation-format *tex-form* 'or (list "\{ \\rm disjunction \}  "
					       " \\vee ")
			  present-tex-logical-operator 50)
(make-presentation-format *tex-form* 'with " \\mbox{ \\rm with }"  present-tex-with 50)
(make-presentation-format *tex-form* 'lambda " \\lambda "   
			  present-tex-lambda-abstraction 50)

(make-presentation-format *tex-form* 'comb " \\choose " present-tex-choose 160)


;;;(make-presentation-format *tex-form* 'iota " \\iota "     present-tex-binding-operator 50)
;;;(make-presentation-format *tex-form* 'forall " \\forall "   present-tex-binding-operator 50)
;;;(make-presentation-format *tex-form* 'forsome " \\exists "   
;;;			  present-tex-binding-operator 50)

(make-presentation-format *tex-form* 'iota " \\iota \\,"     present-tex-quantification-operator 50)
(make-presentation-format *tex-form* 'forall (list " \\forall " "\\forall ")   present-tex-quantification-operator 50)
;; Used to be \\mbox\{ \\rm for every \}
;; 
(make-presentation-format *tex-form* 'forsome (list " \\exists " " \\exists ")   
			  present-tex-quantification-operator 50)
;; Used to be \\mbox\{ \\rm for some \}

(make-presentation-format *tex-form* 'if 'if  present-tex-conditional-formula 50)
;; formerly
;; (make-presentation-format *tex-form* 'if-term 'if  present-tex-conditional-formula 50)

;;;(make-presentation-format *tex-form* 'if-form 'if  present-tex-nonstrict-if 50)
(make-presentation-format *tex-form* 'if-form 'if  present-tex-conditional-formula 50)
(make-presentation-format *tex-form* 'if-pred 'if  present-tex-conditional-formula 50)

;the form IF is not used in the tex form at all. 

(make-presentation-format *tex-form* 'undefined " \\bot "   present-tex-undefined-of-sort 50)
(make-presentation-format *tex-form* 'falselike 'falselike present-subscripted-sort-arg 50)
(make-presentation-format *tex-form* 'is-defined-in-sort " \\downarrow "   present-tex-defined-in-sort 50)
(make-presentation-format *tex-form* 'in-sort 'insort present-tex-in-sort 50)
;;(make-presentation-format *tex-form* 'diff '\' present-tex-differentiation 160)

(make-presentation-format *tex-form* 'sum " \\sum "  present-tex-interval-iteration-operator 50)
(make-presentation-format *tex-form* 'prod " \\prod "  present-tex-interval-iteration-operator 50)
(make-presentation-format *tex-form* 'lim " \\lim "  present-tex-limit-operator 50)


;;;Tex correspondences:

(make-tex-correspondence "alpha" "\\alpha")

(make-tex-correspondence "beta" "\\beta")

(make-tex-correspondence "gamma" "\\gamma")

(make-tex-correspondence "delta" "\\delta")

(make-tex-correspondence "veps" "\\varepsilon")

(make-tex-correspondence "eps" "\\epsilon")

(make-tex-correspondence "sigma" "\\sigma")

(make-tex-correspondence "phi" "\\phi")

(make-tex-correspondence "vphi" "\\varphi")

(make-tex-correspondence "psi" "\\psi")

(make-tex-correspondence "rho" "\\rho")

(make-tex-correspondence "mu" "\\mu")

(make-tex-correspondence "pi" "\\pi")

(make-tex-correspondence "eta" "\\eta")

(make-tex-correspondence "iota" "\\iota")

(make-tex-correspondence "theta" "\\theta")

(make-tex-correspondence "omega" "\\omega")

(make-tex-correspondence "nn" " \{ \\bf N \}")

(make-tex-correspondence "zz" " \{ \\bf Z \}")

(make-tex-correspondence "rr" " \{ \\bf R \}")

(make-tex-correspondence "qq" " \{ \\bf Q \}")

(make-tex-correspondence "pp" " \{ \\bf P \}")

(make-tex-correspondence "uu" " \{ \\bf U \}")

(make-tex-correspondence "<=" " \\leq ")

(make-tex-correspondence "prop" " \\ast ")

